% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supported_dist.methods.R
\name{supported_dist.methods}
\alias{supported_dist.methods}
\title{Supported Distance Methods}
\usage{
supported_dist.methods()
}
\value{
A character vector with currently supported distance methods.
}
\description{
Lists all choices of a distance method currently supported in \code{hclust1d} via \code{stats::dist} call.
}
\examples{

if ("minkowski" \%in\% supported_dist.methods()) {    # the condition under if evaluates to TRUE
   dendrogram <- hclust1d(dist(rnorm(100), method = "minkowski", p = 3))
   plot(dendrogram)
} else {
   stop("Error: minkowski distance method not supported in hclust1d")
}

}
