% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdImpute.R
\name{impute_batches}
\alias{impute_batches}
\title{Impute batches and return completed data frame}
\usage{
impute_batches(data, features, batch, pmm_k, n_trees, seed, save)
}
\arguments{
\item{data}{Original data frame (with missing values)}

\item{features}{Correlation-based vector of ranked features output from running \code{flatten_mat()}}

\item{batch}{Numeric. Batch size.}

\item{pmm_k}{Integer. Number of neighbors considered in imputation. Default at 5.}

\item{n_trees}{Integer. Number of trees used in imputation. Default at 15.}

\item{seed}{Integer. Seed to be set for reproducibility.}

\item{save}{Should the list of individual imputed batches be saved as .rds file to working directory? Default set to FALSE.}
}
\value{
A completed, imputed data set
}
\description{
Impute batches and return completed data frame
}
\details{
Step 1. group data by dividing the \code{row_number()} by batch size (\code{batch}, number of batches set by user) using integer division. Step 2. pass through \code{group_split()} to return a list. Step 3. impute each batch individually and time. Step 4. generate completed (unlisted/joined) imputed data frame
}
\examples{
\dontrun{
impute_batches(data = data, features = flat_mat,
batch = 2,  pmm_k = 5, n_trees = 15, seed = 123,
save = FALSE)
}
}
\references{
Stekhoven, D. J., & Bühlmann, P. (2012). MissForest—non-parametric missing value imputation for mixed-type data. Bioinformatics, 28(1), 112-118.
}
