// (c) The HDF Group
#if !(defined H5C_FRIEND || defined H5C_MODULE)
#error "Do not include this file outside the H5C package!"
#endif
#ifndef H5Cpkg_H
#define H5Cpkg_H
#include "H5Cprivate.h"
#include "H5Clog.h"
#include "H5SLprivate.h"
#define H5C__MAX_EPOCH_MARKERS 10
#define H5C__HASH_TABLE_LEN (64 * 1024)
#define H5C_FLUSH_DEP_PARENT_INIT 8
#ifdef H5C_DO_SANITY_CHECKS
#define H5C__GEN_DLL_PRE_REMOVE_SC(entry_ptr, list_next, list_prev, head_ptr, tail_ptr, len, list_size,      \
                                   fail_val)                                                                 \
    do {                                                                                                     \
        if ((head_ptr) == NULL || (tail_ptr) == NULL || (entry_ptr) == NULL || (len) <= 0 ||                 \
            (list_size) < (entry_ptr)->size ||                                                               \
            ((entry_ptr)->list_prev == NULL && (head_ptr) != (entry_ptr)) ||                                 \
            ((entry_ptr)->list_next == NULL && (tail_ptr) != (entry_ptr)) ||                                 \
            ((len) == 1 &&                                                                                   \
             !((head_ptr) == (entry_ptr) && (tail_ptr) == (entry_ptr) && (entry_ptr)->list_next == NULL &&   \
               (entry_ptr)->list_prev == NULL && (list_size) == (entry_ptr)->size))) {                       \
            HGOTO_ERROR(H5E_CACHE, H5E_SYSTEM, (fail_val), "DLL pre remove SC failed");                      \
        }                                                                                                    \
    } while (0)
#define H5C__GEN_DLL_PRE_INSERT_SC(entry_ptr, list_next, list_prev, head_ptr, tail_ptr, len, list_size,      \
                                   fail_val)                                                                 \
    if ((entry_ptr) == NULL || (entry_ptr)->list_next != NULL || (entry_ptr)->list_prev != NULL ||           \
        (((head_ptr) == NULL || (tail_ptr) == NULL) && (head_ptr) != (tail_ptr)) ||                          \
        ((len) == 0 && ((list_size) > 0 || (head_ptr) != NULL || (tail_ptr) != NULL)) ||                     \
        ((len) == 1 &&                                                                                       \
         ((head_ptr) != (tail_ptr) || (head_ptr) == NULL || (head_ptr)->size != (list_size))) ||             \
        ((len) >= 1 && ((head_ptr) == NULL || (head_ptr)->list_prev != NULL || (tail_ptr) == NULL ||         \
                        (tail_ptr)->list_next != NULL))) {                                                   \
        HGOTO_ERROR(H5E_CACHE, H5E_SYSTEM, (fail_val), "DLL pre insert SC failed");                          \
    }
#define H5C__GEN_DLL_PRE_SIZE_UPDATE_SC(dll_len, dll_size, old_size, new_size, fail_val)                     \
    if ((dll_len) <= 0 || (dll_size) <= 0 || (old_size) <= 0 || (old_size) > (dll_size) ||                   \
        (new_size) <= 0 || ((dll_len) == 1 && (old_size) != (dll_size))) {                                   \
        HGOTO_ERROR(H5E_CACHE, H5E_SYSTEM, (fail_val), "DLL pre size update SC failed");                     \
    }
#define H5C__GEN_DLL_POST_SIZE_UPDATE_SC(dll_len, dll_size, old_size, new_size, fail_val)                    \
    if ((new_size) > (dll_size) || ((dll_len) == 1 && (new_size) != (dll_size))) {                           \
        HGOTO_ERROR(H5E_CACHE, H5E_SYSTEM, (fail_val), "DLL post size update SC failed");                    \
    }
#else
#define H5C__GEN_DLL_PRE_REMOVE_SC(entry_ptr, list_next, list_prev, head_ptr, tail_ptr, len, list_size,      \
                                   fail_val)
#define H5C__GEN_DLL_PRE_INSERT_SC(entry_ptr, list_next, list_prev, head_ptr, tail_ptr, len, list_size,      \
                                   fail_val)
#define H5C__GEN_DLL_PRE_SIZE_UPDATE_SC(dll_len, dll_size, old_size, new_size, fail_val)
#define H5C__GEN_DLL_POST_SIZE_UPDATE_SC(dll_len, dll_size, old_size, new_size, fail_val)
#endif
#define H5C__GEN_DLL_APPEND(entry_ptr, list_next, list_prev, head_ptr, tail_ptr, len, list_size, fail_val)   \
    {                                                                                                        \
        H5C__GEN_DLL_PRE_INSERT_SC(entry_ptr, list_next, list_prev, head_ptr, tail_ptr, len, list_size,      \
                                   fail_val)                                                                 \
        if ((head_ptr) == NULL) {                                                                            \
            (head_ptr) = (entry_ptr);                                                                        \
            (tail_ptr) = (entry_ptr);                                                                        \
        }                                                                                                    \
        else {                                                                                               \
            (tail_ptr)->list_next  = (entry_ptr);                                                            \
            (entry_ptr)->list_prev = (tail_ptr);                                                             \
            (tail_ptr)             = (entry_ptr);                                                            \
        }                                                                                                    \
        (len)++;                                                                                             \
        (list_size) += (entry_ptr)->size;                                                                    \
    }
#define H5C__GEN_DLL_PREPEND(entry_ptr, list_next, list_prev, head_ptr, tail_ptr, len, list_size, fail_val)  \
    {                                                                                                        \
        H5C__GEN_DLL_PRE_INSERT_SC(entry_ptr, list_next, list_prev, head_ptr, tail_ptr, len, list_size,      \
                                   fail_val)                                                                 \
        if ((head_ptr) == NULL) {                                                                            \
            (head_ptr) = (entry_ptr);                                                                        \
            (tail_ptr) = (entry_ptr);                                                                        \
        }                                                                                                    \
        else {                                                                                               \
            (head_ptr)->list_prev  = (entry_ptr);                                                            \
            (entry_ptr)->list_next = (head_ptr);                                                             \
            (head_ptr)             = (entry_ptr);                                                            \
        }                                                                                                    \
        (len)++;                                                                                             \
        (list_size) += (entry_ptr)->size;                                                                    \
    }
#define H5C__GEN_DLL_REMOVE(entry_ptr, list_next, list_prev, head_ptr, tail_ptr, len, list_size, fail_val)   \
    {                                                                                                        \
        H5C__GEN_DLL_PRE_REMOVE_SC(entry_ptr, list_next, list_prev, head_ptr, tail_ptr, len, list_size,      \
                                   fail_val);                                                                \
        if ((head_ptr) == (entry_ptr)) {                                                                     \
            (head_ptr) = (entry_ptr)->list_next;                                                             \
            if ((head_ptr) != NULL)                                                                          \
                (head_ptr)->list_prev = NULL;                                                                \
        }                                                                                                    \
        else                                                                                                 \
            (entry_ptr)->list_prev->list_next = (entry_ptr)->list_next;                                      \
        if ((tail_ptr) == (entry_ptr)) {                                                                     \
            (tail_ptr) = (entry_ptr)->list_prev;                                                             \
            if ((tail_ptr) != NULL)                                                                          \
                (tail_ptr)->list_next = NULL;                                                                \
        }                                                                                                    \
        else                                                                                                 \
            (entry_ptr)->list_next->list_prev = (entry_ptr)->list_prev;                                      \
        (entry_ptr)->list_next = NULL;                                                                       \
        (entry_ptr)->list_prev = NULL;                                                                       \
        (len)--;                                                                                             \
        (list_size) -= (entry_ptr)->size;                                                                    \
    }
#define H5C__GEN_DLL_UPDATE_FOR_SIZE_CHANGE(dll_len, dll_size, old_size, new_size, fail_val)                 \
    {                                                                                                        \
        H5C__GEN_DLL_PRE_SIZE_UPDATE_SC(dll_len, dll_size, old_size, new_size, fail_val)                     \
        (dll_size) -= (old_size);                                                                            \
        (dll_size) += (new_size);                                                                            \
        H5C__GEN_DLL_POST_SIZE_UPDATE_SC(dll_len, dll_size, old_size, new_size, fail_val)                    \
    }
#define H5C__DLL_APPEND(entry_ptr, head_ptr, tail_ptr, len, list_size, fail_val)                             \
    H5C__GEN_DLL_APPEND(entry_ptr, next, prev, head_ptr, tail_ptr, len, list_size, fail_val)
#define H5C__DLL_PREPEND(entry_ptr, head_ptr, tail_ptr, len, list_size, fail_val)                            \
    H5C__GEN_DLL_PREPEND(entry_ptr, next, prev, head_ptr, tail_ptr, len, list_size, fail_val)
#define H5C__DLL_REMOVE(entry_ptr, head_ptr, tail_ptr, len, list_size, fail_val)                             \
    H5C__GEN_DLL_REMOVE(entry_ptr, next, prev, head_ptr, tail_ptr, len, list_size, fail_val)
#define H5C__DLL_UPDATE_FOR_SIZE_CHANGE(dll_len, dll_size, old_size, new_size, fail_val)                     \
    H5C__GEN_DLL_UPDATE_FOR_SIZE_CHANGE(dll_len, dll_size, old_size, new_size, fail_val)
#define H5C__AUX_DLL_APPEND(entry_ptr, head_ptr, tail_ptr, len, list_size, fail_val)                         \
    H5C__GEN_DLL_APPEND(entry_ptr, aux_next, aux_prev, head_ptr, tail_ptr, len, list_size, fail_val)
#define H5C__AUX_DLL_PREPEND(entry_ptr, head_ptr, tail_ptr, len, list_size, fail_val)                        \
    H5C__GEN_DLL_PREPEND(entry_ptr, aux_next, aux_prev, head_ptr, tail_ptr, len, list_size, fail_val)
#define H5C__AUX_DLL_REMOVE(entry_ptr, head_ptr, tail_ptr, len, list_size, fail_val)                         \
    H5C__GEN_DLL_REMOVE(entry_ptr, aux_next, aux_prev, head_ptr, tail_ptr, len, list_size, fail_val)
#define H5C__IL_DLL_APPEND(entry_ptr, head_ptr, tail_ptr, len, list_size, fail_val)                          \
    H5C__GEN_DLL_APPEND(entry_ptr, il_next, il_prev, head_ptr, tail_ptr, len, list_size, fail_val)
#define H5C__IL_DLL_REMOVE(entry_ptr, head_ptr, tail_ptr, len, list_size, fail_val)                          \
    H5C__GEN_DLL_REMOVE(entry_ptr, il_next, il_prev, head_ptr, tail_ptr, len, list_size, fail_val)
#define H5C__UPDATE_CACHE_HIT_RATE_STATS(cache_ptr, hit)                                                     \
    do {                                                                                                     \
        (cache_ptr)->cache_accesses++;                                                                       \
        if (hit)                                                                                             \
            (cache_ptr)->cache_hits++;                                                                       \
    } while (0)
#if H5C_COLLECT_CACHE_STATS
#define H5C__UPDATE_MAX_INDEX_SIZE_STATS(cache_ptr)                                                          \
    do {                                                                                                     \
        if ((cache_ptr)->index_size > (cache_ptr)->max_index_size)                                           \
            (cache_ptr)->max_index_size = (cache_ptr)->index_size;                                           \
        if ((cache_ptr)->clean_index_size > (cache_ptr)->max_clean_index_size)                               \
            (cache_ptr)->max_clean_index_size = (cache_ptr)->clean_index_size;                               \
        if ((cache_ptr)->dirty_index_size > (cache_ptr)->max_dirty_index_size)                               \
            (cache_ptr)->max_dirty_index_size = (cache_ptr)->dirty_index_size;                               \
    } while (0)
#define H5C__UPDATE_STATS_FOR_DIRTY_PIN(cache_ptr, entry_ptr)                                                \
    do {                                                                                                     \
        (cache_ptr)->dirty_pins[(entry_ptr)->type->id]++;                                                    \
    } while (0)
#define H5C__UPDATE_STATS_FOR_UNPROTECT(cache_ptr)                                                           \
    do {                                                                                                     \
        if ((cache_ptr)->slist_len > (cache_ptr)->max_slist_len)                                             \
            (cache_ptr)->max_slist_len = (cache_ptr)->slist_len;                                             \
        if ((cache_ptr)->slist_size > (cache_ptr)->max_slist_size)                                           \
            (cache_ptr)->max_slist_size = (cache_ptr)->slist_size;                                           \
        if ((cache_ptr)->pel_len > (cache_ptr)->max_pel_len)                                                 \
            (cache_ptr)->max_pel_len = (cache_ptr)->pel_len;                                                 \
        if ((cache_ptr)->pel_size > (cache_ptr)->max_pel_size)                                               \
            (cache_ptr)->max_pel_size = (cache_ptr)->pel_size;                                               \
    } while (0)
#define H5C__UPDATE_STATS_FOR_MOVE(cache_ptr, entry_ptr)                                                     \
    do {                                                                                                     \
        if ((cache_ptr)->flush_in_progress)                                                                  \
            (cache_ptr)->cache_flush_moves[(entry_ptr)->type->id]++;                                         \
        if ((entry_ptr)->flush_in_progress)                                                                  \
            (cache_ptr)->entry_flush_moves[(entry_ptr)->type->id]++;                                         \
        (cache_ptr)->moves[(entry_ptr)->type->id]++;                                                         \
        (cache_ptr)->entries_relocated_counter++;                                                            \
    } while (0)
#define H5C__UPDATE_STATS_FOR_ENTRY_SIZE_CHANGE(cache_ptr, entry_ptr, new_size)                              \
    do {                                                                                                     \
        if ((cache_ptr)->flush_in_progress)                                                                  \
            (cache_ptr)->cache_flush_size_changes[(entry_ptr)->type->id]++;                                  \
        if ((entry_ptr)->flush_in_progress)                                                                  \
            (cache_ptr)->entry_flush_size_changes[(entry_ptr)->type->id]++;                                  \
        if ((entry_ptr)->size < (new_size)) {                                                                \
            (cache_ptr)->size_increases[(entry_ptr)->type->id]++;                                            \
            H5C__UPDATE_MAX_INDEX_SIZE_STATS(cache_ptr);                                                     \
            if ((cache_ptr)->slist_size > (cache_ptr)->max_slist_size)                                       \
                (cache_ptr)->max_slist_size = (cache_ptr)->slist_size;                                       \
            if ((cache_ptr)->pl_size > (cache_ptr)->max_pl_size)                                             \
                (cache_ptr)->max_pl_size = (cache_ptr)->pl_size;                                             \
        }                                                                                                    \
        else if ((entry_ptr)->size > (new_size)) {                                                           \
            (cache_ptr)->size_decreases[(entry_ptr)->type->id]++;                                            \
        }                                                                                                    \
    } while (0)
#define H5C__UPDATE_STATS_FOR_HT_INSERTION(cache_ptr)                                                        \
    do {                                                                                                     \
        (cache_ptr)->total_ht_insertions++;                                                                  \
    } while (0)
#define H5C__UPDATE_STATS_FOR_HT_DELETION(cache_ptr)                                                         \
    do {                                                                                                     \
        (cache_ptr)->total_ht_deletions++;                                                                   \
    } while (0)
#define H5C__UPDATE_STATS_FOR_HT_SEARCH(cache_ptr, success, depth)                                           \
    do {                                                                                                     \
        if (success) {                                                                                       \
            (cache_ptr)->successful_ht_searches++;                                                           \
            (cache_ptr)->total_successful_ht_search_depth += depth;                                          \
        }                                                                                                    \
        else {                                                                                               \
            (cache_ptr)->failed_ht_searches++;                                                               \
            (cache_ptr)->total_failed_ht_search_depth += depth;                                              \
        }                                                                                                    \
    } while (0)
#define H5C__UPDATE_STATS_FOR_UNPIN(cache_ptr, entry_ptr)                                                    \
    do {                                                                                                     \
        (cache_ptr)->unpins[(entry_ptr)->type->id]++;                                                        \
    } while (0)
#define H5C__UPDATE_STATS_FOR_PREFETCH(cache_ptr, dirty)                                                     \
    do {                                                                                                     \
        (cache_ptr)->prefetches++;                                                                           \
        if (dirty)                                                                                           \
            (cache_ptr)->dirty_prefetches++;                                                                 \
    } while (0)
#define H5C__UPDATE_STATS_FOR_PREFETCH_HIT(cache_ptr)                                                        \
    do {                                                                                                     \
        (cache_ptr)->prefetch_hits++;                                                                        \
    } while (0)
#define H5C__UPDATE_STATS_FOR_SLIST_SCAN_RESTART(cache_ptr)                                                  \
    do {                                                                                                     \
        (cache_ptr)->slist_scan_restarts++;                                                                  \
    } while (0)
#define H5C__UPDATE_STATS_FOR_LRU_SCAN_RESTART(cache_ptr)                                                    \
    do {                                                                                                     \
        (cache_ptr)->LRU_scan_restarts++;                                                                    \
    } while (0)
#define H5C__UPDATE_STATS_FOR_INDEX_SCAN_RESTART(cache_ptr)                                                  \
    do {                                                                                                     \
        (cache_ptr)->index_scan_restarts++;                                                                  \
    } while (0)
#if H5C_COLLECT_CACHE_ENTRY_STATS
#define H5C__RESET_CACHE_ENTRY_STATS(entry_ptr)                                                              \
    do {                                                                                                     \
        (entry_ptr)->accesses = 0;                                                                           \
        (entry_ptr)->clears   = 0;                                                                           \
        (entry_ptr)->flushes  = 0;                                                                           \
        (entry_ptr)->pins     = 0;                                                                           \
    } while (0)
#define H5C__UPDATE_STATS_FOR_CLEAR(cache_ptr, entry_ptr)                                                    \
    do {                                                                                                     \
        (cache_ptr)->clears[(entry_ptr)->type->id]++;                                                        \
        if ((entry_ptr)->is_pinned)                                                                          \
            (cache_ptr)->pinned_clears[(entry_ptr)->type->id]++;                                             \
        (entry_ptr)->clears++;                                                                               \
    } while (0)
#define H5C__UPDATE_STATS_FOR_FLUSH(cache_ptr, entry_ptr)                                                    \
    do {                                                                                                     \
        (cache_ptr)->flushes[(entry_ptr)->type->id]++;                                                       \
        if ((entry_ptr)->is_pinned)                                                                          \
            (cache_ptr)->pinned_flushes[(entry_ptr)->type->id]++;                                            \
        (entry_ptr)->flushes++;                                                                              \
    } while (0)
#define H5C__UPDATE_STATS_FOR_EVICTION(cache_ptr, entry_ptr, take_ownership)                                 \
    do {                                                                                                     \
        if (take_ownership)                                                                                  \
            (cache_ptr)->take_ownerships[(entry_ptr)->type->id]++;                                           \
        else                                                                                                 \
            (cache_ptr)->evictions[(entry_ptr)->type->id]++;                                                 \
        if ((entry_ptr)->accesses > (cache_ptr)->max_accesses[(entry_ptr)->type->id])                        \
            (cache_ptr)->max_accesses[(entry_ptr)->type->id] = (entry_ptr)->accesses;                        \
        if ((entry_ptr)->accesses < (cache_ptr)->min_accesses[(entry_ptr)->type->id])                        \
            (cache_ptr)->min_accesses[(entry_ptr)->type->id] = (entry_ptr)->accesses;                        \
        if ((entry_ptr)->clears > (cache_ptr)->max_clears[(entry_ptr)->type->id])                            \
            (cache_ptr)->max_clears[(entry_ptr)->type->id] = (entry_ptr)->clears;                            \
        if ((entry_ptr)->flushes > (cache_ptr)->max_flushes[(entry_ptr)->type->id])                          \
            (cache_ptr)->max_flushes[(entry_ptr)->type->id] = (entry_ptr)->flushes;                          \
        if ((entry_ptr)->size > (cache_ptr)->max_size[(entry_ptr)->type->id])                                \
            (cache_ptr)->max_size[(entry_ptr)->type->id] = (entry_ptr)->size;                                \
        if ((entry_ptr)->pins > (cache_ptr)->max_pins[(entry_ptr)->type->id])                                \
            (cache_ptr)->max_pins[(entry_ptr)->type->id] = (entry_ptr)->pins;                                \
    } while (0)
#define H5C__UPDATE_STATS_FOR_INSERTION(cache_ptr, entry_ptr)                                                \
    do {                                                                                                     \
        (cache_ptr)->insertions[(entry_ptr)->type->id]++;                                                    \
        if ((entry_ptr)->is_pinned) {                                                                        \
            (cache_ptr)->pinned_insertions[(entry_ptr)->type->id]++;                                         \
            (cache_ptr)->pins[(entry_ptr)->type->id]++;                                                      \
            (entry_ptr)->pins++;                                                                             \
            if ((cache_ptr)->pel_len > (cache_ptr)->max_pel_len)                                             \
                (cache_ptr)->max_pel_len = (cache_ptr)->pel_len;                                             \
            if ((cache_ptr)->pel_size > (cache_ptr)->max_pel_size)                                           \
                (cache_ptr)->max_pel_size = (cache_ptr)->pel_size;                                           \
        }                                                                                                    \
        if ((cache_ptr)->index_len > (cache_ptr)->max_index_len)                                             \
            (cache_ptr)->max_index_len = (cache_ptr)->index_len;                                             \
        H5C__UPDATE_MAX_INDEX_SIZE_STATS(cache_ptr);                                                         \
        if ((cache_ptr)->slist_len > (cache_ptr)->max_slist_len)                                             \
            (cache_ptr)->max_slist_len = (cache_ptr)->slist_len;                                             \
        if ((cache_ptr)->slist_size > (cache_ptr)->max_slist_size)                                           \
            (cache_ptr)->max_slist_size = (cache_ptr)->slist_size;                                           \
        if ((entry_ptr)->size > (cache_ptr)->max_size[(entry_ptr)->type->id])                                \
            (cache_ptr)->max_size[(entry_ptr)->type->id] = (entry_ptr)->size;                                \
        (cache_ptr)->entries_inserted_counter++;                                                             \
    } while (0)
#define H5C__UPDATE_STATS_FOR_PROTECT(cache_ptr, entry_ptr, hit)                                             \
    do {                                                                                                     \
        if (hit)                                                                                             \
            (cache_ptr)->hits[(entry_ptr)->type->id]++;                                                      \
        else                                                                                                 \
            (cache_ptr)->misses[(entry_ptr)->type->id]++;                                                    \
        if (!(entry_ptr)->is_read_only)                                                                      \
            (cache_ptr)->write_protects[(entry_ptr)->type->id]++;                                            \
        else {                                                                                               \
            (cache_ptr)->read_protects[(entry_ptr)->type->id]++;                                             \
            if ((entry_ptr)->ro_ref_count > (cache_ptr)->max_read_protects[(entry_ptr)->type->id])           \
                (cache_ptr)->max_read_protects[(entry_ptr)->type->id] = (entry_ptr)->ro_ref_count;           \
        }                                                                                                    \
        if ((cache_ptr)->index_len > (cache_ptr)->max_index_len)                                             \
            (cache_ptr)->max_index_len = (cache_ptr)->index_len;                                             \
        H5C__UPDATE_MAX_INDEX_SIZE_STATS(cache_ptr);                                                         \
        if ((cache_ptr)->pl_len > (cache_ptr)->max_pl_len)                                                   \
            (cache_ptr)->max_pl_len = (cache_ptr)->pl_len;                                                   \
        if ((cache_ptr)->pl_size > (cache_ptr)->max_pl_size)                                                 \
            (cache_ptr)->max_pl_size = (cache_ptr)->pl_size;                                                 \
        if ((entry_ptr)->size > (cache_ptr)->max_size[(entry_ptr)->type->id])                                \
            (cache_ptr)->max_size[(entry_ptr)->type->id] = (entry_ptr)->size;                                \
        (entry_ptr)->accesses++;                                                                             \
    } while (0)
#define H5C__UPDATE_STATS_FOR_PIN(cache_ptr, entry_ptr)                                                      \
    do {                                                                                                     \
        (cache_ptr)->pins[(entry_ptr)->type->id]++;                                                          \
        (entry_ptr)->pins++;                                                                                 \
        if ((cache_ptr)->pel_len > (cache_ptr)->max_pel_len)                                                 \
            (cache_ptr)->max_pel_len = (cache_ptr)->pel_len;                                                 \
        if ((cache_ptr)->pel_size > (cache_ptr)->max_pel_size)                                               \
            (cache_ptr)->max_pel_size = (cache_ptr)->pel_size;                                               \
    } while (0)
#else
#define H5C__RESET_CACHE_ENTRY_STATS(entry_ptr)
#define H5C__UPDATE_STATS_FOR_CLEAR(cache_ptr, entry_ptr)                                                    \
    do {                                                                                                     \
        (cache_ptr)->clears[(entry_ptr)->type->id]++;                                                        \
        if ((entry_ptr)->is_pinned)                                                                          \
            (cache_ptr)->pinned_clears[(entry_ptr)->type->id]++;                                             \
    } while (0)
#define H5C__UPDATE_STATS_FOR_FLUSH(cache_ptr, entry_ptr)                                                    \
    do {                                                                                                     \
        (cache_ptr)->flushes[(entry_ptr)->type->id]++;                                                       \
        if ((entry_ptr)->is_pinned)                                                                          \
            (cache_ptr)->pinned_flushes[(entry_ptr)->type->id]++;                                            \
    } while (0)
#define H5C__UPDATE_STATS_FOR_EVICTION(cache_ptr, entry_ptr, take_ownership)                                 \
    do {                                                                                                     \
        if (take_ownership)                                                                                  \
            (cache_ptr)->take_ownerships[(entry_ptr)->type->id]++;                                           \
        else                                                                                                 \
            (cache_ptr)->evictions[(entry_ptr)->type->id]++;                                                 \
    } while (0)
#define H5C__UPDATE_STATS_FOR_INSERTION(cache_ptr, entry_ptr)                                                \
    do {                                                                                                     \
        (cache_ptr)->insertions[(entry_ptr)->type->id]++;                                                    \
        if ((entry_ptr)->is_pinned) {                                                                        \
            (cache_ptr)->pinned_insertions[(entry_ptr)->type->id]++;                                         \
            (cache_ptr)->pins[(entry_ptr)->type->id]++;                                                      \
            if ((cache_ptr)->pel_len > (cache_ptr)->max_pel_len)                                             \
                (cache_ptr)->max_pel_len = (cache_ptr)->pel_len;                                             \
            if ((cache_ptr)->pel_size > (cache_ptr)->max_pel_size)                                           \
                (cache_ptr)->max_pel_size = (cache_ptr)->pel_size;                                           \
        }                                                                                                    \
        if ((cache_ptr)->index_len > (cache_ptr)->max_index_len)                                             \
            (cache_ptr)->max_index_len = (cache_ptr)->index_len;                                             \
        H5C__UPDATE_MAX_INDEX_SIZE_STATS(cache_ptr)                                                          \
        if ((cache_ptr)->slist_len > (cache_ptr)->max_slist_len)                                             \
            (cache_ptr)->max_slist_len = (cache_ptr)->slist_len;                                             \
        if ((cache_ptr)->slist_size > (cache_ptr)->max_slist_size)                                           \
            (cache_ptr)->max_slist_size = (cache_ptr)->slist_size;                                           \
        (cache_ptr)->entries_inserted_counter++;                                                             \
    } while (0)
#define H5C__UPDATE_STATS_FOR_PROTECT(cache_ptr, entry_ptr, hit)                                             \
    do {                                                                                                     \
        if (hit)                                                                                             \
            (cache_ptr)->hits[(entry_ptr)->type->id]++;                                                      \
        else                                                                                                 \
            (cache_ptr)->misses[(entry_ptr)->type->id]++;                                                    \
        if (!(entry_ptr)->is_read_only)                                                                      \
            (cache_ptr)->write_protects[(entry_ptr)->type->id]++;                                            \
        else {                                                                                               \
            (cache_ptr)->read_protects[(entry_ptr)->type->id]++;                                             \
            if ((entry_ptr)->ro_ref_count > (cache_ptr)->max_read_protects[(entry_ptr)->type->id])           \
                (cache_ptr)->max_read_protects[(entry_ptr)->type->id] = (entry_ptr)->ro_ref_count;           \
        }                                                                                                    \
        if ((cache_ptr)->index_len > (cache_ptr)->max_index_len)                                             \
            (cache_ptr)->max_index_len = (cache_ptr)->index_len;                                             \
        H5C__UPDATE_MAX_INDEX_SIZE_STATS(cache_ptr)                                                          \
        if ((cache_ptr)->pl_len > (cache_ptr)->max_pl_len)                                                   \
            (cache_ptr)->max_pl_len = (cache_ptr)->pl_len;                                                   \
        if ((cache_ptr)->pl_size > (cache_ptr)->max_pl_size)                                                 \
            (cache_ptr)->max_pl_size = (cache_ptr)->pl_size;                                                 \
    } while (0)
#define H5C__UPDATE_STATS_FOR_PIN(cache_ptr, entry_ptr)                                                      \
    do {                                                                                                     \
        (cache_ptr)->pins[(entry_ptr)->type->id]++;                                                          \
        if ((cache_ptr)->pel_len > (cache_ptr)->max_pel_len)                                                 \
            (cache_ptr)->max_pel_len = (cache_ptr)->pel_len;                                                 \
        if ((cache_ptr)->pel_size > (cache_ptr)->max_pel_size)                                               \
            (cache_ptr)->max_pel_size = (cache_ptr)->pel_size;                                               \
    } while (0)
#endif
#else
#define H5C__RESET_CACHE_ENTRY_STATS(entry_ptr)                                                              \
    do {                                                                                                     \
    } while (0)
#define H5C__UPDATE_STATS_FOR_DIRTY_PIN(cache_ptr, entry_ptr)                                                \
    do {                                                                                                     \
    } while (0)
#define H5C__UPDATE_STATS_FOR_UNPROTECT(cache_ptr)                                                           \
    do {                                                                                                     \
    } while (0)
#define H5C__UPDATE_STATS_FOR_MOVE(cache_ptr, entry_ptr)                                                     \
    do {                                                                                                     \
    } while (0)
#define H5C__UPDATE_STATS_FOR_ENTRY_SIZE_CHANGE(cache_ptr, entry_ptr, new_size)                              \
    do {                                                                                                     \
    } while (0)
#define H5C__UPDATE_STATS_FOR_HT_INSERTION(cache_ptr)                                                        \
    do {                                                                                                     \
    } while (0)
#define H5C__UPDATE_STATS_FOR_HT_DELETION(cache_ptr)                                                         \
    do {                                                                                                     \
    } while (0)
#define H5C__UPDATE_STATS_FOR_HT_SEARCH(cache_ptr, success, depth)                                           \
    do {                                                                                                     \
    } while (0)
#define H5C__UPDATE_STATS_FOR_INSERTION(cache_ptr, entry_ptr)                                                \
    do {                                                                                                     \
    } while (0)
#define H5C__UPDATE_STATS_FOR_CLEAR(cache_ptr, entry_ptr)                                                    \
    do {                                                                                                     \
    } while (0)
#define H5C__UPDATE_STATS_FOR_FLUSH(cache_ptr, entry_ptr)                                                    \
    do {                                                                                                     \
    } while (0)
#define H5C__UPDATE_STATS_FOR_EVICTION(cache_ptr, entry_ptr, take_ownership)                                 \
    do {                                                                                                     \
    } while (0)
#define H5C__UPDATE_STATS_FOR_PROTECT(cache_ptr, entry_ptr, hit)                                             \
    do {                                                                                                     \
    } while (0)
#define H5C__UPDATE_STATS_FOR_PIN(cache_ptr, entry_ptr)                                                      \
    do {                                                                                                     \
    } while (0)
#define H5C__UPDATE_STATS_FOR_UNPIN(cache_ptr, entry_ptr)                                                    \
    do {                                                                                                     \
    } while (0)
#define H5C__UPDATE_STATS_FOR_PREFETCH(cache_ptr, dirty)                                                     \
    do {                                                                                                     \
    } while (0)
#define H5C__UPDATE_STATS_FOR_PREFETCH_HIT(cache_ptr)                                                        \
    do {                                                                                                     \
    } while (0)
#define H5C__UPDATE_STATS_FOR_SLIST_SCAN_RESTART(cache_ptr)                                                  \
    do {                                                                                                     \
    } while (0)
#define H5C__UPDATE_STATS_FOR_LRU_SCAN_RESTART(cache_ptr)                                                    \
    do {                                                                                                     \
    } while (0)
#define H5C__UPDATE_STATS_FOR_INDEX_SCAN_RESTART(cache_ptr)                                                  \
    do {                                                                                                     \
    } while (0)
#endif
#define H5C__HASH_MASK   ((size_t)(H5C__HASH_TABLE_LEN - 1) << 3)
#define H5C__HASH_FCN(x) (int)((unsigned)((x) & H5C__HASH_MASK) >> 3)
#define H5C__POST_HT_SHIFT_TO_FRONT_SC_CMP(cache_ptr, entry_ptr, k)                                          \
    ((cache_ptr) == NULL || (cache_ptr)->index[k] != (entry_ptr) || (entry_ptr)->ht_prev != NULL)
#define H5C__PRE_HT_SEARCH_SC_CMP(cache_ptr, entry_addr)                                                     \
    ((cache_ptr) == NULL ||                                                                                  \
     (cache_ptr)->index_size != ((cache_ptr)->clean_index_size + (cache_ptr)->dirty_index_size) ||           \
     !H5_addr_defined(entry_addr) || H5C__HASH_FCN(entry_addr) < 0 ||                                        \
     H5C__HASH_FCN(entry_addr) >= H5C__HASH_TABLE_LEN)
#define H5C__POST_SUC_HT_SEARCH_SC_CMP(cache_ptr, entry_ptr, k)                                              \
    ((cache_ptr) == NULL || (cache_ptr)->index_len < 1 || (entry_ptr) == NULL ||                             \
     (cache_ptr)->index_size < (entry_ptr)->size ||                                                          \
     (cache_ptr)->index_size != ((cache_ptr)->clean_index_size + (cache_ptr)->dirty_index_size) ||           \
     (entry_ptr)->size <= 0 || (cache_ptr)->index[k] == NULL ||                                              \
     ((cache_ptr)->index[k] != (entry_ptr) && (entry_ptr)->ht_prev == NULL) ||                               \
     ((cache_ptr)->index[k] == (entry_ptr) && (entry_ptr)->ht_prev != NULL) ||                               \
     ((entry_ptr)->ht_prev != NULL && (entry_ptr)->ht_prev->ht_next != (entry_ptr)) ||                       \
     ((entry_ptr)->ht_next != NULL && (entry_ptr)->ht_next->ht_prev != (entry_ptr)))
#ifdef H5C_DO_SANITY_CHECKS
#define H5C__PRE_HT_INSERT_SC(cache_ptr, entry_ptr, fail_val)                                                \
    if ((cache_ptr) == NULL || (entry_ptr) == NULL || !H5_addr_defined((entry_ptr)->addr) ||                 \
        (entry_ptr)->ht_next != NULL || (entry_ptr)->ht_prev != NULL || (entry_ptr)->size <= 0 ||            \
        H5C__HASH_FCN((entry_ptr)->addr) < 0 || H5C__HASH_FCN((entry_ptr)->addr) >= H5C__HASH_TABLE_LEN ||   \
        (cache_ptr)->index_size != ((cache_ptr)->clean_index_size + (cache_ptr)->dirty_index_size) ||        \
        (cache_ptr)->index_size < (cache_ptr)->clean_index_size ||                                           \
        (cache_ptr)->index_size < (cache_ptr)->dirty_index_size ||                                           \
        (entry_ptr)->ring <= H5C_RING_UNDEFINED || (entry_ptr)->ring >= H5C_RING_NTYPES ||                   \
        (cache_ptr)->index_ring_len[(entry_ptr)->ring] > (cache_ptr)->index_len ||                           \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] > (cache_ptr)->index_size ||                         \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] !=                                                   \
            ((cache_ptr)->clean_index_ring_size[(entry_ptr)->ring] +                                         \
             (cache_ptr)->dirty_index_ring_size[(entry_ptr)->ring]) ||                                       \
        (cache_ptr)->index_len != (cache_ptr)->il_len || (cache_ptr)->index_size != (cache_ptr)->il_size) {  \
        HGOTO_ERROR(H5E_CACHE, H5E_SYSTEM, fail_val, "pre HT insert SC failed");                             \
    }
#define H5C__POST_HT_INSERT_SC(cache_ptr, entry_ptr, fail_val)                                               \
    if ((cache_ptr) == NULL ||                                                                               \
        (cache_ptr)->index_size != ((cache_ptr)->clean_index_size + (cache_ptr)->dirty_index_size) ||        \
        (cache_ptr)->index_size < (cache_ptr)->clean_index_size ||                                           \
        (cache_ptr)->index_size < (cache_ptr)->dirty_index_size ||                                           \
        (cache_ptr)->index_ring_len[(entry_ptr)->ring] == 0 ||                                               \
        (cache_ptr)->index_ring_len[(entry_ptr)->ring] > (cache_ptr)->index_len ||                           \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] > (cache_ptr)->index_size ||                         \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] !=                                                   \
            ((cache_ptr)->clean_index_ring_size[(entry_ptr)->ring] +                                         \
             (cache_ptr)->dirty_index_ring_size[(entry_ptr)->ring]) ||                                       \
        (cache_ptr)->index_len != (cache_ptr)->il_len || (cache_ptr)->index_size != (cache_ptr)->il_size) {  \
        HGOTO_ERROR(H5E_CACHE, H5E_SYSTEM, fail_val, "post HT insert SC failed");                            \
    }
#define H5C__PRE_HT_REMOVE_SC(cache_ptr, entry_ptr, fail_val)                                                \
    if ((cache_ptr) == NULL || (cache_ptr)->index_len < 1 || (entry_ptr) == NULL ||                          \
        (cache_ptr)->index_size < (entry_ptr)->size || !H5_addr_defined((entry_ptr)->addr) ||                \
        (entry_ptr)->size <= 0 || H5C__HASH_FCN((entry_ptr)->addr) < 0 ||                                    \
        H5C__HASH_FCN((entry_ptr)->addr) >= H5C__HASH_TABLE_LEN ||                                           \
        (cache_ptr)->index[H5C__HASH_FCN((entry_ptr)->addr)] == NULL ||                                      \
        ((cache_ptr)->index[H5C__HASH_FCN((entry_ptr)->addr)] != (entry_ptr) &&                              \
         (entry_ptr)->ht_prev == NULL) ||                                                                    \
        ((cache_ptr)->index[H5C__HASH_FCN((entry_ptr)->addr)] == (entry_ptr) &&                              \
         (entry_ptr)->ht_prev != NULL) ||                                                                    \
        (cache_ptr)->index_size != ((cache_ptr)->clean_index_size + (cache_ptr)->dirty_index_size) ||        \
        (cache_ptr)->index_size < (cache_ptr)->clean_index_size ||                                           \
        (cache_ptr)->index_size < (cache_ptr)->dirty_index_size ||                                           \
        (entry_ptr)->ring <= H5C_RING_UNDEFINED || (entry_ptr)->ring >= H5C_RING_NTYPES ||                   \
        (cache_ptr)->index_ring_len[(entry_ptr)->ring] <= 0 ||                                               \
        (cache_ptr)->index_ring_len[(entry_ptr)->ring] > (cache_ptr)->index_len ||                           \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] < (entry_ptr)->size ||                               \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] > (cache_ptr)->index_size ||                         \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] !=                                                   \
            ((cache_ptr)->clean_index_ring_size[(entry_ptr)->ring] +                                         \
             (cache_ptr)->dirty_index_ring_size[(entry_ptr)->ring]) ||                                       \
        (cache_ptr)->index_len != (cache_ptr)->il_len || (cache_ptr)->index_size != (cache_ptr)->il_size) {  \
        HGOTO_ERROR(H5E_CACHE, H5E_SYSTEM, (fail_val), "pre HT remove SC failed");                           \
    }
#define H5C__POST_HT_REMOVE_SC(cache_ptr, entry_ptr, fail_val)                                               \
    if ((cache_ptr) == NULL || (entry_ptr) == NULL || !H5_addr_defined((entry_ptr)->addr) ||                 \
        (entry_ptr)->size <= 0 || (entry_ptr)->ht_next != NULL || (entry_ptr)->ht_prev != NULL ||            \
        (cache_ptr)->index_size != ((cache_ptr)->clean_index_size + (cache_ptr)->dirty_index_size) ||        \
        (cache_ptr)->index_size < (cache_ptr)->clean_index_size ||                                           \
        (cache_ptr)->index_size < (cache_ptr)->dirty_index_size ||                                           \
        (cache_ptr)->index_ring_len[(entry_ptr)->ring] > (cache_ptr)->index_len ||                           \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] > (cache_ptr)->index_size ||                         \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] !=                                                   \
            ((cache_ptr)->clean_index_ring_size[(entry_ptr)->ring] +                                         \
             (cache_ptr)->dirty_index_ring_size[(entry_ptr)->ring]) ||                                       \
        (cache_ptr)->index_len != (cache_ptr)->il_len || (cache_ptr)->index_size != (cache_ptr)->il_size) {  \
        HGOTO_ERROR(H5E_CACHE, H5E_SYSTEM, (fail_val), "post HT remove SC failed");                          \
    }
#define H5C__PRE_HT_SEARCH_SC(cache_ptr, entry_addr, fail_val)                                               \
    if (H5C__PRE_HT_SEARCH_SC_CMP(cache_ptr, entry_addr)) {                                                  \
        HGOTO_ERROR(H5E_CACHE, H5E_SYSTEM, (fail_val), "pre HT search SC failed");                           \
    }
#define H5C__POST_SUC_HT_SEARCH_SC(cache_ptr, entry_ptr, k, fail_val)                                        \
    if (H5C__POST_SUC_HT_SEARCH_SC_CMP(cache_ptr, entry_ptr, k)) {                                           \
        HGOTO_ERROR(H5E_CACHE, H5E_SYSTEM, (fail_val), "post successful HT search SC failed");               \
    }
#define H5C__POST_HT_SHIFT_TO_FRONT_SC(cache_ptr, entry_ptr, k, fail_val)                                    \
    if (H5C__POST_HT_SHIFT_TO_FRONT_SC_CMP(cache_ptr, entry_ptr, k)) {                                       \
        HGOTO_ERROR(H5E_CACHE, H5E_SYSTEM, (fail_val), "post HT shift to front SC failed");                  \
    }
#define H5C__PRE_HT_ENTRY_SIZE_CHANGE_SC(cache_ptr, old_size, new_size, entry_ptr, was_clean, fail_val)      \
    if ((cache_ptr) == NULL || (cache_ptr)->index_len <= 0 || (cache_ptr)->index_size <= 0 ||                \
        (new_size) <= 0 || (old_size) > (cache_ptr)->index_size ||                                           \
        ((cache_ptr)->index_len == 1 && (cache_ptr)->index_size != (old_size)) ||                            \
        (cache_ptr)->index_size != ((cache_ptr)->clean_index_size + (cache_ptr)->dirty_index_size) ||        \
        (cache_ptr)->index_size < (cache_ptr)->clean_index_size ||                                           \
        (cache_ptr)->index_size < (cache_ptr)->dirty_index_size ||                                           \
        ((!(was_clean) || (cache_ptr)->clean_index_size < (old_size)) &&                                     \
         ((was_clean) || (cache_ptr)->dirty_index_size < (old_size))) ||                                     \
        (entry_ptr) == NULL || (entry_ptr)->ring <= H5C_RING_UNDEFINED ||                                    \
        (entry_ptr)->ring >= H5C_RING_NTYPES || (cache_ptr)->index_ring_len[(entry_ptr)->ring] <= 0 ||       \
        (cache_ptr)->index_ring_len[(entry_ptr)->ring] > (cache_ptr)->index_len ||                           \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] > (cache_ptr)->index_size ||                         \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] !=                                                   \
            ((cache_ptr)->clean_index_ring_size[(entry_ptr)->ring] +                                         \
             (cache_ptr)->dirty_index_ring_size[(entry_ptr)->ring]) ||                                       \
        (cache_ptr)->index_len != (cache_ptr)->il_len || (cache_ptr)->index_size != (cache_ptr)->il_size) {  \
        HGOTO_ERROR(H5E_CACHE, H5E_SYSTEM, (fail_val), "pre HT entry size change SC failed");                \
    }
#define H5C__POST_HT_ENTRY_SIZE_CHANGE_SC(cache_ptr, old_size, new_size, entry_ptr, fail_val)                \
    if ((cache_ptr) == NULL || (cache_ptr)->index_len <= 0 || (cache_ptr)->index_size <= 0 ||                \
        (new_size) > (cache_ptr)->index_size ||                                                              \
        (cache_ptr)->index_size != ((cache_ptr)->clean_index_size + (cache_ptr)->dirty_index_size) ||        \
        (cache_ptr)->index_size < (cache_ptr)->clean_index_size ||                                           \
        (cache_ptr)->index_size < (cache_ptr)->dirty_index_size ||                                           \
        ((!((entry_ptr)->is_dirty) || (cache_ptr)->dirty_index_size < (new_size)) &&                         \
         ((entry_ptr)->is_dirty || (cache_ptr)->clean_index_size < (new_size))) ||                           \
        ((cache_ptr)->index_len == 1 && (cache_ptr)->index_size != (new_size)) ||                            \
        (cache_ptr)->index_ring_len[(entry_ptr)->ring] > (cache_ptr)->index_len ||                           \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] > (cache_ptr)->index_size ||                         \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] !=                                                   \
            ((cache_ptr)->clean_index_ring_size[(entry_ptr)->ring] +                                         \
             (cache_ptr)->dirty_index_ring_size[(entry_ptr)->ring]) ||                                       \
        (cache_ptr)->index_len != (cache_ptr)->il_len || (cache_ptr)->index_size != (cache_ptr)->il_size) {  \
        HGOTO_ERROR(H5E_CACHE, H5E_SYSTEM, (fail_val), "post HT entry size change SC failed");               \
    }
#define H5C__PRE_HT_UPDATE_FOR_ENTRY_CLEAN_SC(cache_ptr, entry_ptr, fail_val)                                \
    if ((cache_ptr) == NULL || (cache_ptr)->index_len <= 0 || (entry_ptr) == NULL ||                         \
        (entry_ptr)->is_dirty != false || (cache_ptr)->index_size < (entry_ptr)->size ||                     \
        (cache_ptr)->dirty_index_size < (entry_ptr)->size ||                                                 \
        (cache_ptr)->index_size != ((cache_ptr)->clean_index_size + (cache_ptr)->dirty_index_size) ||        \
        (cache_ptr)->index_size < ((cache_ptr)->clean_index_size) ||                                         \
        (cache_ptr)->index_size < ((cache_ptr)->dirty_index_size) ||                                         \
        (entry_ptr)->ring <= H5C_RING_UNDEFINED || (entry_ptr)->ring >= H5C_RING_NTYPES ||                   \
        (cache_ptr)->index_ring_len[(entry_ptr)->ring] <= 0 ||                                               \
        (cache_ptr)->index_ring_len[(entry_ptr)->ring] > (cache_ptr)->index_len ||                           \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] > (cache_ptr)->index_size ||                         \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] !=                                                   \
            ((cache_ptr)->clean_index_ring_size[(entry_ptr)->ring] +                                         \
             (cache_ptr)->dirty_index_ring_size[(entry_ptr)->ring])) {                                       \
        HGOTO_ERROR(H5E_CACHE, H5E_SYSTEM, (fail_val), "pre HT update for entry clean SC failed");           \
    }
#define H5C__PRE_HT_UPDATE_FOR_ENTRY_DIRTY_SC(cache_ptr, entry_ptr, fail_val)                                \
    if ((cache_ptr) == NULL || (cache_ptr)->index_len <= 0 || (entry_ptr) == NULL ||                         \
        (entry_ptr)->is_dirty != true || (cache_ptr)->index_size < (entry_ptr)->size ||                      \
        (cache_ptr)->clean_index_size < (entry_ptr)->size ||                                                 \
        (cache_ptr)->index_size != ((cache_ptr)->clean_index_size + (cache_ptr)->dirty_index_size) ||        \
        (cache_ptr)->index_size < (cache_ptr)->clean_index_size ||                                           \
        (cache_ptr)->index_size < (cache_ptr)->dirty_index_size ||                                           \
        (entry_ptr)->ring <= H5C_RING_UNDEFINED || (entry_ptr)->ring >= H5C_RING_NTYPES ||                   \
        (cache_ptr)->index_ring_len[(entry_ptr)->ring] <= 0 ||                                               \
        (cache_ptr)->index_ring_len[(entry_ptr)->ring] > (cache_ptr)->index_len ||                           \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] > (cache_ptr)->index_size ||                         \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] !=                                                   \
            ((cache_ptr)->clean_index_ring_size[(entry_ptr)->ring] +                                         \
             (cache_ptr)->dirty_index_ring_size[(entry_ptr)->ring])) {                                       \
        HGOTO_ERROR(H5E_CACHE, H5E_SYSTEM, (fail_val), "pre HT update for entry dirty SC failed");           \
    }
#define H5C__POST_HT_UPDATE_FOR_ENTRY_CLEAN_SC(cache_ptr, entry_ptr, fail_val)                               \
    if ((cache_ptr)->index_size != ((cache_ptr)->clean_index_size + (cache_ptr)->dirty_index_size) ||        \
        (cache_ptr)->index_size < (cache_ptr)->clean_index_size ||                                           \
        (cache_ptr)->index_size < (cache_ptr)->dirty_index_size ||                                           \
        (cache_ptr)->index_ring_len[(entry_ptr)->ring] > (cache_ptr)->index_len ||                           \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] > (cache_ptr)->index_size ||                         \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] !=                                                   \
            ((cache_ptr)->clean_index_ring_size[(entry_ptr)->ring] +                                         \
             (cache_ptr)->dirty_index_ring_size[(entry_ptr)->ring])) {                                       \
        HGOTO_ERROR(H5E_CACHE, H5E_SYSTEM, (fail_val), "post HT update for entry clean SC failed");          \
    }
#define H5C__POST_HT_UPDATE_FOR_ENTRY_DIRTY_SC(cache_ptr, entry_ptr, fail_val)                               \
    if ((cache_ptr)->index_size != ((cache_ptr)->clean_index_size + (cache_ptr)->dirty_index_size) ||        \
        (cache_ptr)->index_size < (cache_ptr)->clean_index_size ||                                           \
        (cache_ptr)->index_size < (cache_ptr)->dirty_index_size ||                                           \
        (cache_ptr)->index_ring_len[(entry_ptr)->ring] > (cache_ptr)->index_len ||                           \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] > (cache_ptr)->index_size ||                         \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] !=                                                   \
            ((cache_ptr)->clean_index_ring_size[(entry_ptr)->ring] +                                         \
             (cache_ptr)->dirty_index_ring_size[(entry_ptr)->ring])) {                                       \
        HGOTO_ERROR(H5E_CACHE, H5E_SYSTEM, (fail_val), "post HT update for entry dirty SC failed");          \
    }
#else
#define H5C__PRE_HT_INSERT_SC(cache_ptr, entry_ptr, fail_val)
#define H5C__POST_HT_INSERT_SC(cache_ptr, entry_ptr, fail_val)
#define H5C__PRE_HT_REMOVE_SC(cache_ptr, entry_ptr, fail_val)
#define H5C__POST_HT_REMOVE_SC(cache_ptr, entry_ptr, fail_val)
#define H5C__PRE_HT_SEARCH_SC(cache_ptr, entry_addr, fail_val)
#define H5C__POST_SUC_HT_SEARCH_SC(cache_ptr, entry_ptr, k, fail_val)
#define H5C__POST_HT_SHIFT_TO_FRONT_SC(cache_ptr, entry_ptr, k, fail_val)
#define H5C__PRE_HT_UPDATE_FOR_ENTRY_CLEAN_SC(cache_ptr, entry_ptr, fail_val)
#define H5C__PRE_HT_UPDATE_FOR_ENTRY_DIRTY_SC(cache_ptr, entry_ptr, fail_val)
#define H5C__PRE_HT_ENTRY_SIZE_CHANGE_SC(cache_ptr, old_size, new_size, entry_ptr, was_clean, fail_val)
#define H5C__POST_HT_ENTRY_SIZE_CHANGE_SC(cache_ptr, old_size, new_size, entry_ptr, fail_val)
#define H5C__POST_HT_UPDATE_FOR_ENTRY_CLEAN_SC(cache_ptr, entry_ptr, fail_val)
#define H5C__POST_HT_UPDATE_FOR_ENTRY_DIRTY_SC(cache_ptr, entry_ptr, fail_val)
#endif
#define H5C__INSERT_IN_INDEX(cache_ptr, entry_ptr, fail_val)                                                 \
    do {                                                                                                     \
        int k;                                                                                               \
        H5C__PRE_HT_INSERT_SC(cache_ptr, entry_ptr, fail_val)                                                \
        k = H5C__HASH_FCN((entry_ptr)->addr);                                                                \
        if ((cache_ptr)->index[k] != NULL) {                                                                 \
            (entry_ptr)->ht_next          = (cache_ptr)->index[k];                                           \
            (entry_ptr)->ht_next->ht_prev = (entry_ptr);                                                     \
        }                                                                                                    \
        (cache_ptr)->index[k] = (entry_ptr);                                                                 \
        (cache_ptr)->index_len++;                                                                            \
        (cache_ptr)->index_size += (entry_ptr)->size;                                                        \
        (cache_ptr)->index_ring_len[(entry_ptr)->ring]++;                                                    \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] += (entry_ptr)->size;                                \
        if ((entry_ptr)->is_dirty) {                                                                         \
            (cache_ptr)->dirty_index_size += (entry_ptr)->size;                                              \
            (cache_ptr)->dirty_index_ring_size[(entry_ptr)->ring] += (entry_ptr)->size;                      \
        }                                                                                                    \
        else {                                                                                               \
            (cache_ptr)->clean_index_size += (entry_ptr)->size;                                              \
            (cache_ptr)->clean_index_ring_size[(entry_ptr)->ring] += (entry_ptr)->size;                      \
        }                                                                                                    \
        if ((entry_ptr)->flush_me_last) {                                                                    \
            (cache_ptr)->num_last_entries++;                                                                 \
            assert((cache_ptr)->num_last_entries <= 2);                                                      \
        }                                                                                                    \
        H5C__IL_DLL_APPEND((entry_ptr), (cache_ptr)->il_head, (cache_ptr)->il_tail, (cache_ptr)->il_len,     \
                           (cache_ptr)->il_size, fail_val);                                                  \
        H5C__UPDATE_STATS_FOR_HT_INSERTION(cache_ptr);                                                       \
        H5C__POST_HT_INSERT_SC(cache_ptr, entry_ptr, fail_val);                                              \
    } while (0)
#define H5C__DELETE_FROM_INDEX(cache_ptr, entry_ptr, fail_val)                                               \
    do {                                                                                                     \
        int k;                                                                                               \
        H5C__PRE_HT_REMOVE_SC(cache_ptr, entry_ptr, fail_val)                                                \
        k = H5C__HASH_FCN((entry_ptr)->addr);                                                                \
        if ((entry_ptr)->ht_next)                                                                            \
            (entry_ptr)->ht_next->ht_prev = (entry_ptr)->ht_prev;                                            \
        if ((entry_ptr)->ht_prev)                                                                            \
            (entry_ptr)->ht_prev->ht_next = (entry_ptr)->ht_next;                                            \
        if ((cache_ptr)->index[k] == (entry_ptr))                                                            \
            (cache_ptr)->index[k] = (entry_ptr)->ht_next;                                                    \
        (entry_ptr)->ht_next = NULL;                                                                         \
        (entry_ptr)->ht_prev = NULL;                                                                         \
        (cache_ptr)->index_len--;                                                                            \
        (cache_ptr)->index_size -= (entry_ptr)->size;                                                        \
        (cache_ptr)->index_ring_len[(entry_ptr)->ring]--;                                                    \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] -= (entry_ptr)->size;                                \
        if ((entry_ptr)->is_dirty) {                                                                         \
            (cache_ptr)->dirty_index_size -= (entry_ptr)->size;                                              \
            (cache_ptr)->dirty_index_ring_size[(entry_ptr)->ring] -= (entry_ptr)->size;                      \
        }                                                                                                    \
        else {                                                                                               \
            (cache_ptr)->clean_index_size -= (entry_ptr)->size;                                              \
            (cache_ptr)->clean_index_ring_size[(entry_ptr)->ring] -= (entry_ptr)->size;                      \
        }                                                                                                    \
        if ((entry_ptr)->flush_me_last) {                                                                    \
            (cache_ptr)->num_last_entries--;                                                                 \
            assert((cache_ptr)->num_last_entries <= 1);                                                      \
        }                                                                                                    \
        H5C__IL_DLL_REMOVE((entry_ptr), (cache_ptr)->il_head, (cache_ptr)->il_tail, (cache_ptr)->il_len,     \
                           (cache_ptr)->il_size, fail_val);                                                  \
        H5C__UPDATE_STATS_FOR_HT_DELETION(cache_ptr);                                                        \
        H5C__POST_HT_REMOVE_SC(cache_ptr, entry_ptr, fail_val);                                              \
    } while (0)
#define H5C__SEARCH_INDEX(cache_ptr, entry_addr, entry_ptr, fail_val)                                        \
    do {                                                                                                     \
        int k;                                                                                               \
        int depth = 0;                                                                                       \
        H5C__PRE_HT_SEARCH_SC(cache_ptr, entry_addr, fail_val);                                              \
        k           = H5C__HASH_FCN(entry_addr);                                                             \
        (entry_ptr) = (cache_ptr)->index[k];                                                                 \
        while (entry_ptr) {                                                                                  \
            if (H5_addr_eq(entry_addr, (entry_ptr)->addr)) {                                                 \
                H5C__POST_SUC_HT_SEARCH_SC(cache_ptr, entry_ptr, k, fail_val);                               \
                if ((entry_ptr) != (cache_ptr)->index[k]) {                                                  \
                    if ((entry_ptr)->ht_next)                                                                \
                        (entry_ptr)->ht_next->ht_prev = (entry_ptr)->ht_prev;                                \
                    assert((entry_ptr)->ht_prev != NULL);                                                    \
                    (entry_ptr)->ht_prev->ht_next  = (entry_ptr)->ht_next;                                   \
                    (cache_ptr)->index[k]->ht_prev = (entry_ptr);                                            \
                    (entry_ptr)->ht_next           = (cache_ptr)->index[k];                                  \
                    (entry_ptr)->ht_prev           = NULL;                                                   \
                    (cache_ptr)->index[k]          = (entry_ptr);                                            \
                    H5C__POST_HT_SHIFT_TO_FRONT_SC(cache_ptr, entry_ptr, k, fail_val);                       \
                }                                                                                            \
                break;                                                                                       \
            }                                                                                                \
            (entry_ptr) = (entry_ptr)->ht_next;                                                              \
            (depth)++;                                                                                       \
        }                                                                                                    \
        H5C__UPDATE_STATS_FOR_HT_SEARCH(cache_ptr, ((entry_ptr) != NULL), depth);                            \
    } while (0)
#define H5C__UPDATE_INDEX_FOR_ENTRY_CLEAN(cache_ptr, entry_ptr, fail_val)                                    \
    do {                                                                                                     \
        H5C__PRE_HT_UPDATE_FOR_ENTRY_CLEAN_SC(cache_ptr, entry_ptr, fail_val);                               \
        (cache_ptr)->dirty_index_size -= (entry_ptr)->size;                                                  \
        (cache_ptr)->dirty_index_ring_size[(entry_ptr)->ring] -= (entry_ptr)->size;                          \
        (cache_ptr)->clean_index_size += (entry_ptr)->size;                                                  \
        (cache_ptr)->clean_index_ring_size[(entry_ptr)->ring] += (entry_ptr)->size;                          \
        H5C__POST_HT_UPDATE_FOR_ENTRY_CLEAN_SC(cache_ptr, entry_ptr, fail_val);                              \
    } while (0)
#define H5C__UPDATE_INDEX_FOR_ENTRY_DIRTY(cache_ptr, entry_ptr, fail_val)                                    \
    do {                                                                                                     \
        H5C__PRE_HT_UPDATE_FOR_ENTRY_DIRTY_SC(cache_ptr, entry_ptr, fail_val);                               \
        (cache_ptr)->clean_index_size -= (entry_ptr)->size;                                                  \
        (cache_ptr)->clean_index_ring_size[(entry_ptr)->ring] -= (entry_ptr)->size;                          \
        (cache_ptr)->dirty_index_size += (entry_ptr)->size;                                                  \
        (cache_ptr)->dirty_index_ring_size[(entry_ptr)->ring] += (entry_ptr)->size;                          \
        H5C__POST_HT_UPDATE_FOR_ENTRY_DIRTY_SC(cache_ptr, entry_ptr, fail_val);                              \
    } while (0)
#define H5C__UPDATE_INDEX_FOR_SIZE_CHANGE(cache_ptr, old_size, new_size, entry_ptr, was_clean, fail_val)     \
    do {                                                                                                     \
        H5C__PRE_HT_ENTRY_SIZE_CHANGE_SC(cache_ptr, old_size, new_size, entry_ptr, was_clean, fail_val);     \
        (cache_ptr)->index_size -= (old_size);                                                               \
        (cache_ptr)->index_size += (new_size);                                                               \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] -= (old_size);                                       \
        (cache_ptr)->index_ring_size[(entry_ptr)->ring] += (new_size);                                       \
        if (was_clean) {                                                                                     \
            (cache_ptr)->clean_index_size -= (old_size);                                                     \
            (cache_ptr)->clean_index_ring_size[(entry_ptr)->ring] -= (old_size);                             \
        }                                                                                                    \
        else {                                                                                               \
            (cache_ptr)->dirty_index_size -= (old_size);                                                     \
            (cache_ptr)->dirty_index_ring_size[(entry_ptr)->ring] -= (old_size);                             \
        }                                                                                                    \
        if ((entry_ptr)->is_dirty) {                                                                         \
            (cache_ptr)->dirty_index_size += (new_size);                                                     \
            (cache_ptr)->dirty_index_ring_size[(entry_ptr)->ring] += (new_size);                             \
        }                                                                                                    \
        else {                                                                                               \
            (cache_ptr)->clean_index_size += (new_size);                                                     \
            (cache_ptr)->clean_index_ring_size[(entry_ptr)->ring] += (new_size);                             \
        }                                                                                                    \
        H5C__DLL_UPDATE_FOR_SIZE_CHANGE((cache_ptr)->il_len, (cache_ptr)->il_size, (old_size), (new_size),   \
                                        (fail_val));                                                         \
        H5C__POST_HT_ENTRY_SIZE_CHANGE_SC(cache_ptr, old_size, new_size, entry_ptr, fail_val);               \
    } while (0)
#ifdef H5C_DO_SLIST_SANITY_CHECKS
#define H5C__ENTRY_IN_SLIST(cache_ptr, entry_ptr) H5C__entry_in_skip_list((cache_ptr), (entry_ptr))
#else
#define H5C__ENTRY_IN_SLIST(cache_ptr, entry_ptr) false
#endif
#ifdef H5C_DO_SANITY_CHECKS
#define H5C__SLIST_INSERT_ENTRY_SC(cache_ptr, entry_ptr)                                                     \
    do {                                                                                                     \
        (cache_ptr)->slist_len_increase++;                                                                   \
        (cache_ptr)->slist_size_increase += (int64_t)((entry_ptr)->size);                                    \
    } while (0)
#define H5C__SLIST_REMOVE_ENTRY_SC(cache_ptr, entry_ptr)                                                     \
    do {                                                                                                     \
        (cache_ptr)->slist_len_increase--;                                                                   \
        (cache_ptr)->slist_size_increase -= (int64_t)((entry_ptr)->size);                                    \
    } while (0)
#define H5C__SLIST_UPDATE_FOR_ENTRY_SIZE_CHANGE_SC(cache_ptr, old_size, new_size)                            \
    do {                                                                                                     \
        (cache_ptr)->slist_size_increase -= (int64_t)(old_size);                                             \
        (cache_ptr)->slist_size_increase += (int64_t)(new_size);                                             \
    } while (0)
#else
#define H5C__SLIST_INSERT_ENTRY_SC(cache_ptr, entry_ptr)
#define H5C__SLIST_REMOVE_ENTRY_SC(cache_ptr, entry_ptr)
#define H5C__SLIST_UPDATE_FOR_ENTRY_SIZE_CHANGE_SC(cache_ptr, old_size, new_size)
#endif
#define H5C__INSERT_ENTRY_IN_SLIST(cache_ptr, entry_ptr, fail_val)                                           \
    do {                                                                                                     \
        assert(cache_ptr);                                                                                   \
                                                                                                             \
        if ((cache_ptr)->slist_enabled) {                                                                    \
            assert(entry_ptr);                                                                               \
            assert((entry_ptr)->size > 0);                                                                   \
            assert(H5_addr_defined((entry_ptr)->addr));                                                      \
            assert(!(entry_ptr)->in_slist);                                                                  \
            assert(!H5C__ENTRY_IN_SLIST((cache_ptr), (entry_ptr)));                                          \
            assert((entry_ptr)->ring > H5C_RING_UNDEFINED);                                                  \
            assert((entry_ptr)->ring < H5C_RING_NTYPES);                                                     \
            assert((cache_ptr)->slist_ring_len[(entry_ptr)->ring] <= (cache_ptr)->slist_len);                \
            assert((cache_ptr)->slist_ring_size[(entry_ptr)->ring] <= (cache_ptr)->slist_size);              \
            assert((cache_ptr)->slist_ptr);                                                                  \
                                                                                                             \
            if (H5SL_insert((cache_ptr)->slist_ptr, entry_ptr, &((entry_ptr)->addr)) < 0)                    \
                HGOTO_ERROR(H5E_CACHE, H5E_BADVALUE, (fail_val), "can't insert entry in skip list");         \
                                                                                                             \
            (entry_ptr)->in_slist      = true;                                                               \
            (cache_ptr)->slist_changed = true;                                                               \
            (cache_ptr)->slist_len++;                                                                        \
            (cache_ptr)->slist_size += (entry_ptr)->size;                                                    \
            ((cache_ptr)->slist_ring_len[(entry_ptr)->ring])++;                                              \
            ((cache_ptr)->slist_ring_size[(entry_ptr)->ring]) += (entry_ptr)->size;                          \
            H5C__SLIST_INSERT_ENTRY_SC(cache_ptr, entry_ptr);                                                \
                                                                                                             \
            assert((cache_ptr)->slist_len > 0);                                                              \
            assert((cache_ptr)->slist_size > 0);                                                             \
        }                                                                                                    \
        else {                                                                          \
            assert((cache_ptr)->slist_len == 0);                                                             \
            assert((cache_ptr)->slist_size == 0);                                                            \
        }                                                                                                    \
    } while (0)
#define H5C__REMOVE_ENTRY_FROM_SLIST(cache_ptr, entry_ptr, during_flush, fail_val)                           \
    do {                                                                                                     \
        assert(cache_ptr);                                                                                   \
                                                                                                             \
        if ((cache_ptr)->slist_enabled) {                                                                    \
            assert(entry_ptr);                                                                               \
            assert(!(entry_ptr)->is_read_only);                                                              \
            assert((entry_ptr)->ro_ref_count == 0);                                                          \
            assert((entry_ptr)->size > 0);                                                                   \
            assert((entry_ptr)->in_slist);                                                                   \
            assert((cache_ptr)->slist_ptr);                                                                  \
            assert((entry_ptr)->ring > H5C_RING_UNDEFINED);                                                  \
            assert((entry_ptr)->ring < H5C_RING_NTYPES);                                                     \
            assert((cache_ptr)->slist_ring_len[(entry_ptr)->ring] <= (cache_ptr)->slist_len);                \
            assert((cache_ptr)->slist_ring_size[(entry_ptr)->ring] <= (cache_ptr)->slist_size);              \
            assert((cache_ptr)->slist_size >= (entry_ptr)->size);                                            \
                                                                                                             \
            if (H5SL_remove((cache_ptr)->slist_ptr, &(entry_ptr)->addr) != (entry_ptr))                      \
                HGOTO_ERROR(H5E_CACHE, H5E_BADVALUE, (fail_val), "can't delete entry from skip list");       \
                                                                                                             \
            assert((cache_ptr)->slist_len > 0);                                                              \
            if (!(during_flush))                                                                             \
                (cache_ptr)->slist_changed = true;                                                           \
            (cache_ptr)->slist_len--;                                                                        \
            assert((cache_ptr)->slist_size >= (entry_ptr)->size);                                            \
            (cache_ptr)->slist_size -= (entry_ptr)->size;                                                    \
            (cache_ptr)->slist_ring_len[(entry_ptr)->ring]--;                                                \
            assert((cache_ptr)->slist_ring_size[(entry_ptr)->ring] >= (entry_ptr)->size);                    \
            ((cache_ptr)->slist_ring_size[(entry_ptr)->ring]) -= (entry_ptr)->size;                          \
            H5C__SLIST_REMOVE_ENTRY_SC(cache_ptr, entry_ptr);                                                \
            (entry_ptr)->in_slist = false;                                                                   \
        }                                                                                                    \
        else {                                                                          \
            assert((cache_ptr)->slist_len == 0);                                                             \
            assert((cache_ptr)->slist_size == 0);                                                            \
        }                                                                                                    \
    } while (0)
#define H5C__UPDATE_SLIST_FOR_SIZE_CHANGE(cache_ptr, old_size, new_size)                                     \
    do {                                                                                                     \
        assert(cache_ptr);                                                                                   \
                                                                                                             \
        if ((cache_ptr)->slist_enabled) {                                                                    \
            assert((old_size) > 0);                                                                          \
            assert((new_size) > 0);                                                                          \
            assert((old_size) <= (cache_ptr)->slist_size);                                                   \
            assert((cache_ptr)->slist_len > 0);                                                              \
            assert((cache_ptr)->slist_len > 1 || (cache_ptr)->slist_size == (old_size));                     \
            assert((entry_ptr)->ring > H5C_RING_UNDEFINED);                                                  \
            assert((entry_ptr)->ring < H5C_RING_NTYPES);                                                     \
            assert((cache_ptr)->slist_ring_len[(entry_ptr)->ring] <= (cache_ptr)->slist_len);                \
            assert((cache_ptr)->slist_ring_size[(entry_ptr)->ring] <= (cache_ptr)->slist_size);              \
                                                                                                             \
            (cache_ptr)->slist_size -= (old_size);                                                           \
            (cache_ptr)->slist_size += (new_size);                                                           \
                                                                                                             \
            assert((cache_ptr)->slist_ring_size[(entry_ptr)->ring] >= (old_size));                           \
                                                                                                             \
            (cache_ptr)->slist_ring_size[(entry_ptr)->ring] -= (old_size);                                   \
            (cache_ptr)->slist_ring_size[(entry_ptr)->ring] += (new_size);                                   \
                                                                                                             \
            H5C__SLIST_UPDATE_FOR_ENTRY_SIZE_CHANGE_SC(cache_ptr, old_size, new_size);                       \
                                                                                                             \
            assert((new_size) <= (cache_ptr)->slist_size);                                                   \
            assert((cache_ptr)->slist_len > 1 || (cache_ptr)->slist_size == (new_size));                     \
        }                                                                                                    \
        else {                                                                          \
            assert((cache_ptr)->slist_len == 0);                                                             \
            assert((cache_ptr)->slist_size == 0);                                                            \
        }                                                                                                    \
    } while (0)
#if H5C_MAINTAIN_CLEAN_AND_DIRTY_LRU_LISTS
#define H5C__UPDATE_RP_FOR_EVICTION_CD_LRU(cache_ptr, entry_ptr, fail_val)                                   \
    do {                                                                                                     \
                                                                                                  \
        if ((entry_ptr)->is_dirty) {                                                                         \
            H5C__AUX_DLL_REMOVE((entry_ptr), (cache_ptr)->dLRU_head_ptr, (cache_ptr)->dLRU_tail_ptr,         \
                                (cache_ptr)->dLRU_list_len, (cache_ptr)->dLRU_list_size, (fail_val))         \
        }                                                                                                    \
        else {                                                                                               \
            H5C__AUX_DLL_REMOVE((entry_ptr), (cache_ptr)->cLRU_head_ptr, (cache_ptr)->cLRU_tail_ptr,         \
                                (cache_ptr)->cLRU_list_len, (cache_ptr)->cLRU_list_size, (fail_val))         \
        }                                                                                                    \
    } while (0)
#define H5C__UPDATE_RP_FOR_FLUSH_CD_LRU(cache_ptr, entry_ptr, fail_val)                                      \
    do {                                                                                                     \
                                                                                                  \
        if ((entry_ptr)->is_dirty) {                                                                         \
            H5C__AUX_DLL_REMOVE((entry_ptr), (cache_ptr)->dLRU_head_ptr, (cache_ptr)->dLRU_tail_ptr,         \
                                (cache_ptr)->dLRU_list_len, (cache_ptr)->dLRU_list_size, (fail_val))         \
        }                                                                                                    \
        else {                                                                                               \
            H5C__AUX_DLL_REMOVE((entry_ptr), (cache_ptr)->cLRU_head_ptr, (cache_ptr)->cLRU_tail_ptr,         \
                                (cache_ptr)->cLRU_list_len, (cache_ptr)->cLRU_list_size, (fail_val))         \
        }                                                                                                    \
                                                                                                             \
        H5C__AUX_DLL_PREPEND((entry_ptr), (cache_ptr)->cLRU_head_ptr, (cache_ptr)->cLRU_tail_ptr,            \
                             (cache_ptr)->cLRU_list_len, (cache_ptr)->cLRU_list_size, (fail_val))            \
    } while (0)
#define H5C__UPDATE_RP_FOR_INSERT_APPEND_CD_LRU(cache_ptr, entry_ptr, fail_val)                              \
    do {                                                                                                     \
                                                                                                  \
        if ((entry_ptr)->is_dirty) {                                                                         \
            H5C__AUX_DLL_APPEND((entry_ptr), (cache_ptr)->dLRU_head_ptr, (cache_ptr)->dLRU_tail_ptr,         \
                                (cache_ptr)->dLRU_list_len, (cache_ptr)->dLRU_list_size, (fail_val));        \
        }                                                                                                    \
        else {                                                                                               \
            H5C__AUX_DLL_APPEND((entry_ptr), (cache_ptr)->cLRU_head_ptr, (cache_ptr)->cLRU_tail_ptr,         \
                                (cache_ptr)->cLRU_list_len, (cache_ptr)->cLRU_list_size, (fail_val));        \
        }                                                                                                    \
    } while (0)
#define H5C__UPDATE_RP_FOR_INSERTION_CD_LRU(cache_ptr, entry_ptr, fail_val)                                  \
    do {                                                                                                     \
                                                                                                  \
        if ((entry_ptr)->is_dirty) {                                                                         \
            H5C__AUX_DLL_PREPEND((entry_ptr), (cache_ptr)->dLRU_head_ptr, (cache_ptr)->dLRU_tail_ptr,        \
                                 (cache_ptr)->dLRU_list_len, (cache_ptr)->dLRU_list_size, (fail_val))        \
        }                                                                                                    \
        else {                                                                                               \
            H5C__AUX_DLL_PREPEND((entry_ptr), (cache_ptr)->cLRU_head_ptr, (cache_ptr)->cLRU_tail_ptr,        \
                                 (cache_ptr)->cLRU_list_len, (cache_ptr)->cLRU_list_size, (fail_val))        \
        }                                                                                                    \
    } while (0)
#define H5C__UPDATE_RP_FOR_PROTECT_CD_LRU(cache_ptr, entry_ptr, fail_val)                                    \
    {                                                                                                        \
                               \
        if ((entry_ptr)->is_dirty) {                                                                         \
            H5C__AUX_DLL_REMOVE((entry_ptr), (cache_ptr)->dLRU_head_ptr, (cache_ptr)->dLRU_tail_ptr,         \
                                (cache_ptr)->dLRU_list_len, (cache_ptr)->dLRU_list_size, (fail_val))         \
        }                                                                                                    \
        else {                                                                                               \
            H5C__AUX_DLL_REMOVE((entry_ptr), (cache_ptr)->cLRU_head_ptr, (cache_ptr)->cLRU_tail_ptr,         \
                                (cache_ptr)->cLRU_list_len, (cache_ptr)->cLRU_list_size, (fail_val))         \
        }                                                                                                    \
    }                                                                                                        \
    while (0)
#define H5C__UPDATE_RP_FOR_MOVE_CD_LRU(cache_ptr, entry_ptr, was_dirty, fail_val)                            \
    do {                                                                                                     \
                                                                                                  \
        if (was_dirty) {                                                                                     \
            H5C__AUX_DLL_REMOVE((entry_ptr), (cache_ptr)->dLRU_head_ptr, (cache_ptr)->dLRU_tail_ptr,         \
                                (cache_ptr)->dLRU_list_len, (cache_ptr)->dLRU_list_size, (fail_val));        \
        }                                                                                                    \
        else {                                                                                               \
            H5C__AUX_DLL_REMOVE((entry_ptr), (cache_ptr)->cLRU_head_ptr, (cache_ptr)->cLRU_tail_ptr,         \
                                (cache_ptr)->cLRU_list_len, (cache_ptr)->cLRU_list_size, (fail_val));        \
        }                                                                                                    \
                                                                                                             \
                                                                                                  \
        if ((entry_ptr)->is_dirty) {                                                                         \
            H5C__AUX_DLL_PREPEND((entry_ptr), (cache_ptr)->dLRU_head_ptr, (cache_ptr)->dLRU_tail_ptr,        \
                                 (cache_ptr)->dLRU_list_len, (cache_ptr)->dLRU_list_size, (fail_val));       \
        }                                                                                                    \
        else {                                                                                               \
            H5C__AUX_DLL_PREPEND((entry_ptr), (cache_ptr)->cLRU_head_ptr, (cache_ptr)->cLRU_tail_ptr,        \
                                 (cache_ptr)->cLRU_list_len, (cache_ptr)->cLRU_list_size, (fail_val));       \
        }                                                                                                    \
    } while (0)
#define H5C__UPDATE_RP_FOR_SIZE_CHANGE_CD_LRU(cache_ptr, entry_ptr, new_size, fail_val)                      \
    do {                                                                                                     \
                                                                                                  \
        if ((entry_ptr)->is_dirty) {                                                                         \
            H5C__DLL_UPDATE_FOR_SIZE_CHANGE((cache_ptr)->dLRU_list_len, (cache_ptr)->dLRU_list_size,         \
                                            (entry_ptr)->size, (new_size), (fail_val))                       \
        }                                                                                                    \
        else {                                                                                               \
            H5C__DLL_UPDATE_FOR_SIZE_CHANGE((cache_ptr)->cLRU_list_len, (cache_ptr)->cLRU_list_size,         \
                                            (entry_ptr)->size, (new_size), (fail_val))                       \
        }                                                                                                    \
    } while (0)
#define H5C__UPDATE_RP_FOR_UNPIN_CD_LRU(cache_ptr, entry_ptr, fail_val)                                      \
    do {                                                                                                     \
                                                                                                  \
        if ((entry_ptr)->is_dirty) {                                                                         \
            H5C__AUX_DLL_PREPEND((entry_ptr), (cache_ptr)->dLRU_head_ptr, (cache_ptr)->dLRU_tail_ptr,        \
                                 (cache_ptr)->dLRU_list_len, (cache_ptr)->dLRU_list_size, (fail_val))        \
        }                                                                                                    \
        else {                                                                                               \
            H5C__AUX_DLL_PREPEND((entry_ptr), (cache_ptr)->cLRU_head_ptr, (cache_ptr)->cLRU_tail_ptr,        \
                                 (cache_ptr)->cLRU_list_len, (cache_ptr)->cLRU_list_size, (fail_val))        \
        }                                                                                                    \
    } while (0)
#define H5C__UPDATE_RP_FOR_UNPROTECT_CD_LRU(cache_ptr, entry_ptr, fail_val)                                  \
    do {                                                                                                     \
                                                                                                  \
        if ((entry_ptr)->is_dirty) {                                                                         \
            H5C__AUX_DLL_PREPEND((entry_ptr), (cache_ptr)->dLRU_head_ptr, (cache_ptr)->dLRU_tail_ptr,        \
                                 (cache_ptr)->dLRU_list_len, (cache_ptr)->dLRU_list_size, (fail_val))        \
        }                                                                                                    \
        else {                                                                                               \
            H5C__AUX_DLL_PREPEND((entry_ptr), (cache_ptr)->cLRU_head_ptr, (cache_ptr)->cLRU_tail_ptr,        \
                                 (cache_ptr)->cLRU_list_len, (cache_ptr)->cLRU_list_size, (fail_val))        \
        }                                                                                                    \
    } while (0)
#else
#define H5C__UPDATE_RP_FOR_EVICTION_CD_LRU(cache_ptr, entry_ptr, fail_val)
#define H5C__UPDATE_RP_FOR_FLUSH_CD_LRU(cache_ptr, entry_ptr, fail_val)
#define H5C__UPDATE_RP_FOR_INSERT_APPEND_CD_LRU(cache_ptr, entry_ptr, fail_val)
#define H5C__UPDATE_RP_FOR_INSERTION_CD_LRU(cache_ptr, entry_ptr, fail_val)
#define H5C__UPDATE_RP_FOR_PROTECT_CD_LRU(cache_ptr, entry_ptr, fail_val)
#define H5C__UPDATE_RP_FOR_MOVE_CD_LRU(cache_ptr, entry_ptr, was_dirty, fail_val)
#define H5C__UPDATE_RP_FOR_SIZE_CHANGE_CD_LRU(cache_ptr, entry_ptr, new_size, fail_val)
#define H5C__UPDATE_RP_FOR_UNPIN_CD_LRU(cache_ptr, entry_ptr, fail_val)
#define H5C__UPDATE_RP_FOR_UNPROTECT_CD_LRU(cache_ptr, entry_ptr, fail_val)
#endif
#define H5C__UPDATE_RP_FOR_EVICTION(cache_ptr, entry_ptr, fail_val)                                          \
    do {                                                                                                     \
        assert(cache_ptr);                                                                                   \
        assert(entry_ptr);                                                                                   \
        assert(!(entry_ptr)->is_protected);                                                                  \
        assert(!(entry_ptr)->is_read_only);                                                                  \
        assert((entry_ptr)->ro_ref_count == 0);                                                              \
        assert(!(entry_ptr)->is_pinned);                                                                     \
        assert((entry_ptr)->size > 0);                                                                       \
                                                                                                             \
                                                             \
        H5C__DLL_REMOVE((entry_ptr), (cache_ptr)->LRU_head_ptr, (cache_ptr)->LRU_tail_ptr,                   \
                        (cache_ptr)->LRU_list_len, (cache_ptr)->LRU_list_size, (fail_val))                   \
                                                                                                             \
                                  \
        H5C__UPDATE_RP_FOR_EVICTION_CD_LRU(cache_ptr, entry_ptr, fail_val);                                  \
    } while (0)
#define H5C__UPDATE_RP_FOR_FLUSH(cache_ptr, entry_ptr, fail_val)                                             \
    do {                                                                                                     \
        assert(cache_ptr);                                                                                   \
        assert(entry_ptr);                                                                                   \
        assert(!(entry_ptr)->is_protected);                                                                  \
        assert(!(entry_ptr)->is_read_only);                                                                  \
        assert((entry_ptr)->ro_ref_count == 0);                                                              \
        assert((entry_ptr)->size > 0);                                                                       \
                                                                                                             \
        if (!(entry_ptr)->is_pinned) {                                                                       \
                                                                                              \
            H5C__DLL_REMOVE((entry_ptr), (cache_ptr)->LRU_head_ptr, (cache_ptr)->LRU_tail_ptr,               \
                            (cache_ptr)->LRU_list_len, (cache_ptr)->LRU_list_size, (fail_val))               \
                                                                                                             \
            H5C__DLL_PREPEND((entry_ptr), (cache_ptr)->LRU_head_ptr, (cache_ptr)->LRU_tail_ptr,              \
                             (cache_ptr)->LRU_list_len, (cache_ptr)->LRU_list_size, (fail_val))              \
                                                                                                             \
                                           \
            H5C__UPDATE_RP_FOR_FLUSH_CD_LRU(cache_ptr, entry_ptr, fail_val);                                 \
        }                                                                                                    \
    } while (0)
#define H5C__UPDATE_RP_FOR_INSERT_APPEND(cache_ptr, entry_ptr, fail_val)                                     \
    do {                                                                                                     \
        assert(cache_ptr);                                                                                   \
        assert(entry_ptr);                                                                                   \
        assert(!(entry_ptr)->is_protected);                                                                  \
        assert(!(entry_ptr)->is_read_only);                                                                  \
        assert((entry_ptr)->ro_ref_count == 0);                                                              \
        assert((entry_ptr)->size > 0);                                                                       \
                                                                                                             \
        if ((entry_ptr)->is_pinned) {                                                                        \
            H5C__DLL_PREPEND((entry_ptr), (cache_ptr)->pel_head_ptr, (cache_ptr)->pel_tail_ptr,              \
                             (cache_ptr)->pel_len, (cache_ptr)->pel_size, (fail_val))                        \
        }                                                                                                    \
        else {                                                                                               \
                                              \
            H5C__DLL_APPEND((entry_ptr), (cache_ptr)->LRU_head_ptr, (cache_ptr)->LRU_tail_ptr,               \
                            (cache_ptr)->LRU_list_len, (cache_ptr)->LRU_list_size, (fail_val))               \
                                                                                                             \
                                           \
            H5C__UPDATE_RP_FOR_INSERT_APPEND_CD_LRU(cache_ptr, entry_ptr, fail_val);                         \
        }                                                                                                    \
    } while (0)
#define H5C__UPDATE_RP_FOR_INSERTION(cache_ptr, entry_ptr, fail_val)                                         \
    do {                                                                                                     \
        assert(cache_ptr);                                                                                   \
        assert(entry_ptr);                                                                                   \
        assert(!(entry_ptr)->is_protected);                                                                  \
        assert(!(entry_ptr)->is_read_only);                                                                  \
        assert((entry_ptr)->ro_ref_count == 0);                                                              \
        assert((entry_ptr)->size > 0);                                                                       \
                                                                                                             \
        if ((entry_ptr)->is_pinned) {                                                                        \
            H5C__DLL_PREPEND((entry_ptr), (cache_ptr)->pel_head_ptr, (cache_ptr)->pel_tail_ptr,              \
                             (cache_ptr)->pel_len, (cache_ptr)->pel_size, (fail_val))                        \
        }                                                                                                    \
        else {                                                                                               \
                                              \
            H5C__DLL_PREPEND((entry_ptr), (cache_ptr)->LRU_head_ptr, (cache_ptr)->LRU_tail_ptr,              \
                             (cache_ptr)->LRU_list_len, (cache_ptr)->LRU_list_size, (fail_val))              \
                                                                                                             \
                                           \
            H5C__UPDATE_RP_FOR_INSERTION_CD_LRU(cache_ptr, entry_ptr, fail_val);                             \
        }                                                                                                    \
    } while (0)
#define H5C__UPDATE_RP_FOR_PROTECT(cache_ptr, entry_ptr, fail_val)                                           \
    do {                                                                                                     \
        assert(cache_ptr);                                                                                   \
        assert(entry_ptr);                                                                                   \
        assert(!(entry_ptr)->is_protected);                                                                  \
        assert(!(entry_ptr)->is_read_only);                                                                  \
        assert((entry_ptr)->ro_ref_count == 0);                                                              \
        assert((entry_ptr)->size > 0);                                                                       \
                                                                                                             \
        if ((entry_ptr)->is_pinned) {                                                                        \
            H5C__DLL_REMOVE((entry_ptr), (cache_ptr)->pel_head_ptr, (cache_ptr)->pel_tail_ptr,               \
                            (cache_ptr)->pel_len, (cache_ptr)->pel_size, (fail_val))                         \
        }                                                                                                    \
        else {                                                                                               \
                                                        \
            H5C__DLL_REMOVE((entry_ptr), (cache_ptr)->LRU_head_ptr, (cache_ptr)->LRU_tail_ptr,               \
                            (cache_ptr)->LRU_list_len, (cache_ptr)->LRU_list_size, (fail_val))               \
                                                                                                             \
                                           \
            H5C__UPDATE_RP_FOR_PROTECT_CD_LRU(cache_ptr, entry_ptr, fail_val);                               \
        }                                                                                                    \
                                                                                                             \
                                                                                                  \
        H5C__DLL_APPEND((entry_ptr), (cache_ptr)->pl_head_ptr, (cache_ptr)->pl_tail_ptr,                     \
                        (cache_ptr)->pl_len, (cache_ptr)->pl_size, (fail_val))                               \
    } while (0)
#define H5C__UPDATE_RP_FOR_MOVE(cache_ptr, entry_ptr, was_dirty, fail_val)                                   \
    do {                                                                                                     \
        assert(cache_ptr);                                                                                   \
        assert(entry_ptr);                                                                                   \
        assert(!(entry_ptr)->is_read_only);                                                                  \
        assert((entry_ptr)->ro_ref_count == 0);                                                              \
        assert((entry_ptr)->size > 0);                                                                       \
                                                                                                             \
        if (!(entry_ptr)->is_pinned && !(entry_ptr)->is_protected) {                                         \
                                                                                              \
            H5C__DLL_REMOVE((entry_ptr), (cache_ptr)->LRU_head_ptr, (cache_ptr)->LRU_tail_ptr,               \
                            (cache_ptr)->LRU_list_len, (cache_ptr)->LRU_list_size, (fail_val))               \
                                                                                                             \
            H5C__DLL_PREPEND((entry_ptr), (cache_ptr)->LRU_head_ptr, (cache_ptr)->LRU_tail_ptr,              \
                             (cache_ptr)->LRU_list_len, (cache_ptr)->LRU_list_size, (fail_val))              \
                                                                                                             \
                                           \
            H5C__UPDATE_RP_FOR_MOVE_CD_LRU(cache_ptr, entry_ptr, was_dirty, fail_val);                       \
        }                                                                                                    \
    } while (0)
#ifdef H5_HAVE_PARALLEL
#define H5C__UPDATE_RP_FOR_SIZE_CHANGE_COLL(cache_ptr, entry_ptr, new_size, fail_val)                        \
    do {                                                                                                     \
        if ((entry_ptr)->coll_access) {                                                                      \
            H5C__DLL_UPDATE_FOR_SIZE_CHANGE((cache_ptr)->coll_list_len, (cache_ptr)->coll_list_size,         \
                                            (entry_ptr)->size, (new_size), (fail_val));                      \
        }                                                                                                    \
    } while (0)
#else
#define H5C__UPDATE_RP_FOR_SIZE_CHANGE_COLL(cache_ptr, entry_ptr, new_size, fail_val)
#endif
#define H5C__UPDATE_RP_FOR_SIZE_CHANGE(cache_ptr, entry_ptr, new_size, fail_val)                             \
    do {                                                                                                     \
        assert(cache_ptr);                                                                                   \
        assert(entry_ptr);                                                                                   \
        assert(!(entry_ptr)->is_protected);                                                                  \
        assert(!(entry_ptr)->is_read_only);                                                                  \
        assert((entry_ptr)->ro_ref_count == 0);                                                              \
        assert((entry_ptr)->size > 0);                                                                       \
        assert(new_size > 0);                                                                                \
                                                                                                             \
                                                \
        H5C__UPDATE_RP_FOR_SIZE_CHANGE_COLL(cache_ptr, entry_ptr, new_size, fail_val);                       \
                                                                                                             \
        if ((entry_ptr)->is_pinned) {                                                                        \
            H5C__DLL_UPDATE_FOR_SIZE_CHANGE((cache_ptr)->pel_len, (cache_ptr)->pel_size, (entry_ptr)->size,  \
                                            (new_size), (fail_val))                                          \
        }                                                                                                    \
        else {                                                                                               \
                                                            \
            H5C__DLL_UPDATE_FOR_SIZE_CHANGE((cache_ptr)->LRU_list_len, (cache_ptr)->LRU_list_size,           \
                                            (entry_ptr)->size, (new_size), (fail_val))                       \
                                                                                                             \
                                           \
            H5C__UPDATE_RP_FOR_SIZE_CHANGE_CD_LRU(cache_ptr, entry_ptr, new_size, fail_val);                 \
        }                                                                                                    \
    } while (0)
#define H5C__UPDATE_RP_FOR_UNPIN(cache_ptr, entry_ptr, fail_val)                                             \
    do {                                                                                                     \
        assert(cache_ptr);                                                                                   \
        assert(entry_ptr);                                                                                   \
        assert(!(entry_ptr)->is_protected);                                                                  \
        assert(!(entry_ptr)->is_read_only);                                                                  \
        assert((entry_ptr)->ro_ref_count == 0);                                                              \
        assert((entry_ptr)->is_pinned);                                                                      \
        assert((entry_ptr)->size > 0);                                                                       \
                                                                                                             \
                                                                                                  \
        H5C__DLL_REMOVE((entry_ptr), (cache_ptr)->pel_head_ptr, (cache_ptr)->pel_tail_ptr,                   \
                        (cache_ptr)->pel_len, (cache_ptr)->pel_size, (fail_val));                            \
                                                                                                             \
                                                  \
        H5C__DLL_PREPEND((entry_ptr), (cache_ptr)->LRU_head_ptr, (cache_ptr)->LRU_tail_ptr,                  \
                         (cache_ptr)->LRU_list_len, (cache_ptr)->LRU_list_size, (fail_val));                 \
                                                                                                             \
                                               \
        H5C__UPDATE_RP_FOR_UNPIN_CD_LRU(cache_ptr, entry_ptr, fail_val);                                     \
    } while (0)
#define H5C__UPDATE_RP_FOR_UNPROTECT(cache_ptr, entry_ptr, fail_val)                                         \
    do {                                                                                                     \
        assert(cache_ptr);                                                                                   \
        assert(entry_ptr);                                                                                   \
        assert((entry_ptr)->is_protected);                                                                   \
        assert((entry_ptr)->size > 0);                                                                       \
                                                                                                             \
                                                                                                  \
        H5C__DLL_REMOVE((entry_ptr), (cache_ptr)->pl_head_ptr, (cache_ptr)->pl_tail_ptr,                     \
                        (cache_ptr)->pl_len, (cache_ptr)->pl_size, (fail_val))                               \
                                                                                                             \
        if ((entry_ptr)->is_pinned) {                                                                        \
            H5C__DLL_PREPEND((entry_ptr), (cache_ptr)->pel_head_ptr, (cache_ptr)->pel_tail_ptr,              \
                             (cache_ptr)->pel_len, (cache_ptr)->pel_size, (fail_val))                        \
        }                                                                                                    \
        else {                                                                                               \
                                              \
            H5C__DLL_PREPEND((entry_ptr), (cache_ptr)->LRU_head_ptr, (cache_ptr)->LRU_tail_ptr,              \
                             (cache_ptr)->LRU_list_len, (cache_ptr)->LRU_list_size, (fail_val))              \
                                                                                                             \
                                           \
            H5C__UPDATE_RP_FOR_UNPROTECT_CD_LRU(cache_ptr, entry_ptr, fail_val);                             \
        }                                                                                                    \
    } while (0)
#ifdef H5_HAVE_PARALLEL
#define H5C__COLL_DLL_PREPEND(entry_ptr, head_ptr, tail_ptr, len, list_size, fail_val)                       \
    H5C__GEN_DLL_PREPEND(entry_ptr, coll_next, coll_prev, head_ptr, tail_ptr, len, list_size, fail_val)
#define H5C__COLL_DLL_REMOVE(entry_ptr, head_ptr, tail_ptr, len, list_size, fail_val)                        \
    H5C__GEN_DLL_REMOVE(entry_ptr, coll_next, coll_prev, head_ptr, tail_ptr, len, list_size, fail_val)
#define H5C__INSERT_IN_COLL_LIST(cache_ptr, entry_ptr, fail_val)                                             \
    do {                                                                                                     \
        assert(cache_ptr);                                                                                   \
        assert(entry_ptr);                                                                                   \
                                                                                                             \
                                                      \
        H5C__COLL_DLL_PREPEND((entry_ptr), (cache_ptr)->coll_head_ptr, (cache_ptr)->coll_tail_ptr,           \
                              (cache_ptr)->coll_list_len, (cache_ptr)->coll_list_size, (fail_val))           \
    } while (0)
#define H5C__REMOVE_FROM_COLL_LIST(cache_ptr, entry_ptr, fail_val)                                           \
    do {                                                                                                     \
        assert(cache_ptr);                                                                                   \
        assert(entry_ptr);                                                                                   \
                                                                                                             \
                                                                \
        H5C__COLL_DLL_REMOVE((entry_ptr), (cache_ptr)->coll_head_ptr, (cache_ptr)->coll_tail_ptr,            \
                             (cache_ptr)->coll_list_len, (cache_ptr)->coll_list_size, (fail_val))            \
    } while (0)
#define H5C__MOVE_TO_TOP_IN_COLL_LIST(cache_ptr, entry_ptr, fail_val)                                        \
    do {                                                                                                     \
        assert(cache_ptr);                                                                                   \
        assert(entry_ptr);                                                                                   \
                                                                                                             \
                                               \
        H5C__COLL_DLL_REMOVE((entry_ptr), (cache_ptr)->coll_head_ptr, (cache_ptr)->coll_tail_ptr,            \
                             (cache_ptr)->coll_list_len, (cache_ptr)->coll_list_size, (fail_val))            \
                                                                                                             \
        H5C__COLL_DLL_PREPEND((entry_ptr), (cache_ptr)->coll_head_ptr, (cache_ptr)->coll_tail_ptr,           \
                              (cache_ptr)->coll_list_len, (cache_ptr)->coll_list_size, (fail_val))           \
                                                                                                             \
    } while (0)
#endif
typedef struct H5C_tag_info_t {
    haddr_t            tag;
    H5C_cache_entry_t *head;
    size_t             entry_cnt;
    bool               corked;
    UT_hash_handle hh;
} H5C_tag_info_t;
struct H5C_t {
    bool                       flush_in_progress;
    H5C_log_info_t            *log_info;
    void                      *aux_ptr;
    int32_t                    max_type_id;
    const H5C_class_t *const  *class_table_ptr;
    size_t                     max_cache_size;
    size_t                     min_clean_size;
    H5C_write_permitted_func_t check_write_permitted;
    bool                       write_permitted;
    H5C_log_flush_func_t       log_flush;
    bool                       evictions_enabled;
    bool                       close_warning_received;
    uint32_t           index_len;
    size_t             index_size;
    uint32_t           index_ring_len[H5C_RING_NTYPES];
    size_t             index_ring_size[H5C_RING_NTYPES];
    size_t             clean_index_size;
    size_t             clean_index_ring_size[H5C_RING_NTYPES];
    size_t             dirty_index_size;
    size_t             dirty_index_ring_size[H5C_RING_NTYPES];
    H5C_cache_entry_t *index[H5C__HASH_TABLE_LEN];
    uint32_t           il_len;
    size_t             il_size;
    H5C_cache_entry_t *il_head;
    H5C_cache_entry_t *il_tail;
    int64_t            entries_removed_counter;
    H5C_cache_entry_t *last_entry_removed_ptr;
    H5C_cache_entry_t *entry_watched_for_removal;
    bool     slist_enabled;
    bool     slist_changed;
    uint32_t slist_len;
    size_t   slist_size;
    uint32_t slist_ring_len[H5C_RING_NTYPES];
    size_t   slist_ring_size[H5C_RING_NTYPES];
    H5SL_t  *slist_ptr;
    uint32_t num_last_entries;
#ifdef H5C_DO_SANITY_CHECKS
    int32_t slist_len_increase;
    int64_t slist_size_increase;
#endif
    H5C_tag_info_t *tag_list;
    bool            ignore_tags;
    uint32_t        num_objs_corked;
    uint32_t           pl_len;
    size_t             pl_size;
    H5C_cache_entry_t *pl_head_ptr;
    H5C_cache_entry_t *pl_tail_ptr;
    uint32_t           pel_len;
    size_t             pel_size;
    H5C_cache_entry_t *pel_head_ptr;
    H5C_cache_entry_t *pel_tail_ptr;
    uint32_t           LRU_list_len;
    size_t             LRU_list_size;
    H5C_cache_entry_t *LRU_head_ptr;
    H5C_cache_entry_t *LRU_tail_ptr;
#if H5C_MAINTAIN_CLEAN_AND_DIRTY_LRU_LISTS
    uint32_t           cLRU_list_len;
    size_t             cLRU_list_size;
    H5C_cache_entry_t *cLRU_head_ptr;
    H5C_cache_entry_t *cLRU_tail_ptr;
    uint32_t           dLRU_list_len;
    size_t             dLRU_list_size;
    H5C_cache_entry_t *dLRU_head_ptr;
    H5C_cache_entry_t *dLRU_tail_ptr;
#endif
#ifdef H5_HAVE_PARALLEL
    uint32_t           coll_list_len;
    size_t             coll_list_size;
    H5C_cache_entry_t *coll_head_ptr;
    H5C_cache_entry_t *coll_tail_ptr;
    H5SL_t *coll_write_list;
#endif
    bool                size_increase_possible;
    bool                flash_size_increase_possible;
    size_t              flash_size_increase_threshold;
    bool                size_decrease_possible;
    bool                resize_enabled;
    bool                cache_full;
    bool                size_decreased;
    bool                resize_in_progress;
    bool                msic_in_progress;
    H5C_auto_size_ctl_t resize_ctl;
    int32_t           epoch_markers_active;
    bool              epoch_marker_active[H5C__MAX_EPOCH_MARKERS];
    int32_t           epoch_marker_ringbuf[H5C__MAX_EPOCH_MARKERS + 1];
    int32_t           epoch_marker_ringbuf_first;
    int32_t           epoch_marker_ringbuf_last;
    int32_t           epoch_marker_ringbuf_size;
    H5C_cache_entry_t epoch_markers[H5C__MAX_EPOCH_MARKERS];
    int64_t cache_hits;
    int64_t cache_accesses;
    H5C_cache_image_ctl_t image_ctl;
    bool                  serialization_in_progress;
    bool                  load_image;
    bool                  image_loaded;
    bool                  delete_image;
    haddr_t               image_addr;
    hsize_t               image_len;
    hsize_t               image_data_len;
    int64_t               entries_loaded_counter;
    int64_t               entries_inserted_counter;
    int64_t               entries_relocated_counter;
    int64_t               entry_fd_height_change_counter;
    uint32_t              num_entries_in_image;
    H5C_image_entry_t    *image_entries;
    void                 *image_buffer;
    bool rdfsm_settled;
    bool mdfsm_settled;
#if H5C_COLLECT_CACHE_STATS
    int64_t hits[H5C__MAX_NUM_TYPE_IDS + 1];
    int64_t misses[H5C__MAX_NUM_TYPE_IDS + 1];
    int64_t write_protects[H5C__MAX_NUM_TYPE_IDS + 1];
    int64_t read_protects[H5C__MAX_NUM_TYPE_IDS + 1];
    int32_t max_read_protects[H5C__MAX_NUM_TYPE_IDS + 1];
    int64_t insertions[H5C__MAX_NUM_TYPE_IDS + 1];
    int64_t pinned_insertions[H5C__MAX_NUM_TYPE_IDS + 1];
    int64_t clears[H5C__MAX_NUM_TYPE_IDS + 1];
    int64_t flushes[H5C__MAX_NUM_TYPE_IDS + 1];
    int64_t evictions[H5C__MAX_NUM_TYPE_IDS + 1];
    int64_t take_ownerships[H5C__MAX_NUM_TYPE_IDS + 1];
    int64_t moves[H5C__MAX_NUM_TYPE_IDS + 1];
    int64_t entry_flush_moves[H5C__MAX_NUM_TYPE_IDS + 1];
    int64_t cache_flush_moves[H5C__MAX_NUM_TYPE_IDS + 1];
    int64_t pins[H5C__MAX_NUM_TYPE_IDS + 1];
    int64_t unpins[H5C__MAX_NUM_TYPE_IDS + 1];
    int64_t dirty_pins[H5C__MAX_NUM_TYPE_IDS + 1];
    int64_t pinned_flushes[H5C__MAX_NUM_TYPE_IDS + 1];
    int64_t pinned_clears[H5C__MAX_NUM_TYPE_IDS + 1];
    int64_t size_increases[H5C__MAX_NUM_TYPE_IDS + 1];
    int64_t size_decreases[H5C__MAX_NUM_TYPE_IDS + 1];
    int64_t entry_flush_size_changes[H5C__MAX_NUM_TYPE_IDS + 1];
    int64_t cache_flush_size_changes[H5C__MAX_NUM_TYPE_IDS + 1];
    int64_t  total_ht_insertions;
    int64_t  total_ht_deletions;
    int64_t  successful_ht_searches;
    int64_t  total_successful_ht_search_depth;
    int64_t  failed_ht_searches;
    int64_t  total_failed_ht_search_depth;
    uint32_t max_index_len;
    size_t   max_index_size;
    size_t   max_clean_index_size;
    size_t   max_dirty_index_size;
    uint32_t max_slist_len;
    size_t   max_slist_size;
    uint32_t max_pl_len;
    size_t   max_pl_size;
    uint32_t max_pel_len;
    size_t   max_pel_size;
    int64_t calls_to_msic;
    int64_t total_entries_skipped_in_msic;
    int64_t total_dirty_pf_entries_skipped_in_msic;
    int64_t total_entries_scanned_in_msic;
    int32_t max_entries_skipped_in_msic;
    int32_t max_dirty_pf_entries_skipped_in_msic;
    int32_t max_entries_scanned_in_msic;
    int64_t entries_scanned_to_make_space;
    int64_t slist_scan_restarts;
    int64_t LRU_scan_restarts;
    int64_t index_scan_restarts;
    int32_t images_created;
    int32_t images_read;
    int32_t images_loaded;
    hsize_t last_image_size;
    int64_t prefetches;
    int64_t dirty_prefetches;
    int64_t prefetch_hits;
#if H5C_COLLECT_CACHE_ENTRY_STATS
    int32_t max_accesses[H5C__MAX_NUM_TYPE_IDS + 1];
    int32_t min_accesses[H5C__MAX_NUM_TYPE_IDS + 1];
    int32_t max_clears[H5C__MAX_NUM_TYPE_IDS + 1];
    int32_t max_flushes[H5C__MAX_NUM_TYPE_IDS + 1];
    size_t  max_size[H5C__MAX_NUM_TYPE_IDS + 1];
    int32_t max_pins[H5C__MAX_NUM_TYPE_IDS + 1];
#endif
#endif
    char prefix[H5C__PREFIX_LEN];
#ifndef NDEBUG
    int64_t get_entry_ptr_from_addr_counter;
#endif
};
typedef int (*H5C_tag_iter_cb_t)(H5C_cache_entry_t *entry, void *ctx);
H5_DLL herr_t H5C__prep_image_for_file_close(H5F_t *f, bool *image_generated);
H5_DLL herr_t H5C__auto_adjust_cache_size(H5F_t *f, bool write_permitted);
H5_DLL herr_t H5C__autoadjust__ageout__remove_all_markers(H5C_t *cache_ptr);
H5_DLL herr_t H5C__autoadjust__ageout__remove_excess_markers(H5C_t *cache_ptr);
H5_DLL herr_t H5C__flash_increase_cache_size(H5C_t *cache_ptr, size_t old_entry_size, size_t new_entry_size);
H5_DLL herr_t H5C__flush_invalidate_cache(H5F_t *f, unsigned flags);
H5_DLL herr_t H5C__flush_ring(H5F_t *f, H5C_ring_t ring, unsigned flags);
H5_DLL herr_t H5C__flush_single_entry(H5F_t *f, H5C_cache_entry_t *entry_ptr, unsigned flags);
H5_DLL herr_t H5C__generate_cache_image(H5F_t *f, H5C_t *cache_ptr);
H5_DLL herr_t H5C__load_cache_image(H5F_t *f);
H5_DLL herr_t H5C__make_space_in_cache(H5F_t *f, size_t space_needed, bool write_permitted);
H5_DLL herr_t H5C__serialize_cache(H5F_t *f);
H5_DLL herr_t H5C__serialize_single_entry(H5F_t *f, H5C_t *cache_ptr, H5C_cache_entry_t *entry_ptr);
H5_DLL herr_t H5C__iter_tagged_entries(H5C_t *cache, haddr_t tag, bool match_global, H5C_tag_iter_cb_t cb,
                                       void *cb_ctx);
H5_DLL herr_t H5C__tag_entry(H5C_t *cache_ptr, H5C_cache_entry_t *entry_ptr);
H5_DLL herr_t H5C__untag_entry(H5C_t *cache, H5C_cache_entry_t *entry);
H5_DLL herr_t H5C__get_cache_image_config(const H5C_t *cache_ptr, H5C_cache_image_ctl_t *config_ptr);
H5_DLL herr_t H5C__image_stats(H5C_t *cache_ptr, bool print_header);
#ifdef H5C_DO_SLIST_SANITY_CHECKS
H5_DLL bool H5C__entry_in_skip_list(H5C_t *cache_ptr, H5C_cache_entry_t *target_ptr);
#endif
#ifdef H5C_DO_EXTREME_SANITY_CHECKS
H5_DLL herr_t H5C__validate_lru_list(H5C_t *cache_ptr);
H5_DLL herr_t H5C__validate_pinned_entry_list(H5C_t *cache_ptr);
H5_DLL herr_t H5C__validate_protected_entry_list(H5C_t *cache_ptr);
#endif
#ifdef H5C_TESTING
H5_DLL herr_t H5C__verify_cork_tag_test(hid_t fid, H5O_token_t tag_token, bool status);
#endif
#endif
