% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Classes_H5R.R
\docType{class}
\name{H5R_OBJECT-class}
\alias{H5R_OBJECT-class}
\alias{H5R_OBJECT}
\title{Class for HDF5 Object-references.}
\value{
Object of class \code{\link[=H5R_OBJECT]{H5R_OBJECT}}.
}
\description{
\code{H5R_OBJECT} is the reference class for objects. Users should not create this class by themselves, but use the appropriate 
and instead use the \code{create_reference} methods of \code{H5D}, \code{H5Group} or \code{H5File} classes.
}
\section{Methods}{

\describe{
\item{\code{new(num = 0, id = NULL)}}{

Create a new reference for object; Usually, users shouldn't have to call this, but use the \code{create_reference}
method of a dataset, group of committed datatype}

\item{\code{dereference(object_access_pl = h5const$H5P_DEFAULT, obj = NULL)}}{

Dereference an H5R reference. The file the reference is pointing to is assigned automatically
This function implements the HDF5-API function H5Rdereference.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/v1_10/group___h5_r.html} for details.

\strong{Parameters}
\describe{
\item{obj}{Overriding the default file the reference is referring to}
\item{object_access_pl}{The object-access property list. Currently always the default}
}}
}}

\author{
Holger Hoefling
}
