% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src_summaries.R
\name{plot_hdpglm}
\alias{plot_hdpglm}
\title{Plot posterior distribution of tau and posterior expectation of beta}
\usage{
plot_hdpglm(
  samples,
  X = NULL,
  W = NULL,
  ncol.taus = 1,
  ncol.betas = NULL,
  ncol.w = NULL,
  nrow.w = NULL,
  smooth.line = FALSE,
  pred.pexp.beta = FALSE,
  title.tau = NULL,
  true.tau = NULL,
  title.beta = NULL,
  tau.x.axis.size = 1.1,
  tau.y.axis.size = 1.1,
  tau.title.size = 1.2,
  tau.panel.title.size = 1.4,
  tau.legend.size = 1,
  beta.x.axis.size = 1.1,
  beta.y.axis.size = 1.1,
  beta.title.size = 1.2,
  beta.panel.title.size = 1.4,
  beta.legend.size = 1,
  tau.xlab = NULL
)
}
\arguments{
\item{samples}{an output of the function \code{\link{hdpGLM}}}

\item{X}{a string vector with the name of the first-level covariates whose associated tau should be displayed}

\item{W}{a string vector with the name of the context-level covariate(s) whose linear effect will be displayed. If \code{NULL}, the linear effect tau of all context-level covariates are displayed. Note: the context-level covariate must have been included in the estimation of the model.}

\item{ncol.taus}{integer with the number of columns of the grid containing the posterior distribution of tau}

\item{ncol.betas}{integer with the number of columns of the posterior expectation of betas as function of context-level features}

\item{ncol.w}{integer with the number of columns to use to display the different context-level covariates}

\item{nrow.w}{integer with the number of rows to use to display the different context-level covariates}

\item{smooth.line}{boolean, if \code{TRUE} the plot will display a regression line representing the regression of the posterior expectation of the linear coefficients betas on the context-level covariates. Default \code{FALSE}}

\item{pred.pexp.beta}{boolean, if \code{TRUE} the plots will display a line with the predicted posterior expectation of betas obtained using the posterior expectation of taus, the linear coefficients of the expectation of beta}

\item{title.tau}{string, the title for the posterior distribution of the context effects}

\item{true.tau}{a \code{data.frame} with four columns. The first must be named \code{w} and it indicates the index of each context-level covariate, starting with 0 for the intercept term. The second column named \code{beta} must contain the indexes of the betas of individual-level covariates, starting with 0 for the intercept term. The third column named \code{Parameter} must be named \code{tau<w><beta>}, where \code{w} and \code{beta} must be the actual values displayed in the columns \code{w} and \code{beta}. Finally, it must have a column named \code{True} with the true value of the parameter.}

\item{title.beta}{string, the title for the posterior expectation of beta as function of context-level covariate}

\item{tau.x.axis.size}{numeric, relative size of the x-axis of the plot with tau}

\item{tau.y.axis.size}{numeric, relative size of the y-axis of the plot with tau}

\item{tau.title.size}{numeric, relative size of the title of the plot with tau}

\item{tau.panel.title.size}{numeric, relative size of the title of the panels of the plot with tau}

\item{tau.legend.size}{numeric, relative size of the legend of the plot with tau}

\item{beta.x.axis.size}{numeric, relative size of the x-axis of the plot with beta}

\item{beta.y.axis.size}{numeric, relative size of the y-axis of the plot with beta}

\item{beta.title.size}{numeric, relative size of the title of the plot with beta}

\item{beta.panel.title.size}{numeric, relative size of the title of the panels of the plot with beta}

\item{beta.legend.size}{numeric, relative size of the legend of the plot with beta}

\item{tau.xlab}{string, the label of the x-axis for the plot with tau}
}
\description{
this function creates a plot with two grids. One is the grid with posterior expectation of betas as function of context-level covariates. The other is the posterior distribution of tau
}
\examples{

library(magrittr)
# Note: this example is just for illustration. MCMC iterations are very reduced
set.seed(10)
n = 20
data.context1 = tibble::data_frame(x1 = rnorm(n, -3),
                                   x2 = rnorm(n,  3),
                                   z  = sample(1:3, n, replace=TRUE),
                                   y  =I(z==1) * (3 + 4*x1 - x2 + rnorm(n)) +
                                       I(z==2) * (3 + 2*x1 + x2 + rnorm(n)) +
                                       I(z==3) * (3 - 4*x1 - x2 + rnorm(n)) ,
                                   w = 20
                                   ) 
data.context2 = tibble::data_frame(x1 = rnorm(n, -3),
                                   x2 = rnorm(n,  3),
                                   z  = sample(1:2, n, replace=TRUE),
                                   y  =I(z==1) * (1 + 3*x1 - 2*x2 + rnorm(n)) +
                                       I(z==2) * (1 - 2*x1 +   x2 + rnorm(n)),
                                   w = 10
                                   ) 
data = data.context1 \%>\%
    dplyr::bind_rows(data.context2)

## estimation
mcmc    = list(burn.in=1, n.iter=50)
samples = hdpGLM(y ~ x1 + x2, y ~ w, data=data, mcmc=mcmc, n.display=1)

plot_hdpglm(samples)
plot_hdpglm(samples, ncol.taus=2, ncol.betas=2, X='x1')
plot_hdpglm(samples, ncol.taus=2, ncol.betas=2, X='x1', ncol.w=2, nrow.w=1,
            pred.pexp.beta=TRUE,smooth.line=TRUE )


}
