% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{get_supported_models}
\alias{get_supported_models}
\alias{supported_models}
\alias{models}
\alias{models_supported}
\title{Supported models and their hyperparameters}
\usage{
get_supported_models()
}
\value{
Vector of currently-supported algorithms.
}
\description{
\strong{Random Forest}: "rf". Regression and classification.
Implemented via \code{ranger}.
\itemize{
  \item{mtry: Fraction of variables to consider for each split}
  \item{splitrule: Splitting rule. For classification either "gini" or
  "extratrees". For regression either "variance", "extratrees", or
  "maxstat".}
  \item{min.node.size: Minimal node size.}
}

\strong{k-nearest neighbors}: "knn". Regression and classification.
Implemented via \code{kknn}.
\itemize{
  \item{kmax: Number of neighbors to consider.}
  \item{distance: Minkowsky distance parameter, (0, Inf). 1 = Manhatten, 2 =
  Euclidian, -> Inf = Chebyshev.}
  \item{kernal: Kernal to use. Possible choices are "rectangular" (standard
  knn), "triangular", "epanechnikov", "biweight", "triweight", "cos", "inv",
  "gaussian", "rank", or "optimal".}
}
}
\seealso{
\code{\link{hyperparameters}} for more detail on hyperparameter
defaults and specifications
}
