% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-hai-hyperbolic.R
\name{hai_hyperbolic_vec}
\alias{hai_hyperbolic_vec}
\title{Vector Function Hyperbolic}
\usage{
hai_hyperbolic_vec(.x, .scale_type = c("sin", "cos", "tan", "sincos"))
}
\arguments{
\item{.x}{A numeric vector}

\item{.scale_type}{A character of one of the following: "sin","cos","tan","sincos"}
}
\value{
A numeric vector
}
\description{
Takes a numeric vector and will return a vector of one of the following:
\itemize{
\item "sin"
\item "cos"
\item "tan"
\item "sincos" This will do value = sin(x) * cos(x)
}
}
\details{
Takes a numeric vector and will return a vector of one of the following:
\itemize{
\item "sin"
\item "cos"
\item "tan"
\item "sincos"
}

This function can be used on it's own. It is also the basis for the function
\code{\link[=hai_hyperbolic_augment]{hai_hyperbolic_augment()}}.
}
\examples{
suppressPackageStartupMessages(library(dplyr))

len_out    = 25
by_unit    = "month"
start_date = as.Date("2021-01-01")

data_tbl <- tibble(
  date_col = seq.Date(from = start_date, length.out = len_out, by = by_unit),
  a    = rnorm(len_out),
  b    = runif(len_out)
)

vec_1 <- hai_hyperbolic_vec(data_tbl$b, .scale_type = "sin")
vec_2 <- hai_hyperbolic_vec(data_tbl$b, .scale_type = "cos")
vec_3 <- hai_hyperbolic_vec(data_tbl$b, .scale_type = "sincos")

plot(data_tbl$b)
lines(vec_1, col = "blue")
lines(vec_2, col = "red")
lines(vec_3, col = "green")

}
\seealso{
Other Vector Function: 
\code{\link{hai_fourier_discrete_vec}()},
\code{\link{hai_fourier_vec}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Vector Function}
