% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-hai-winsorized-truncate.R
\name{hai_winsorized_truncate_vec}
\alias{hai_winsorized_truncate_vec}
\title{Vector Function Winsorize Truncate}
\usage{
hai_winsorized_truncate_vec(.x, .fraction = 0.05)
}
\arguments{
\item{.x}{A numeric vector}

\item{.fraction}{A positive fractional between 0 and 0.5 that is passed to the
\code{stats::quantile} paramater of \code{probs}.}
}
\value{
A numeric vector
}
\description{
Takes a numeric vector and will return a vector of winsorized values.
}
\details{
Takes a numeric vector and will return a winsorized vector of values that have
been truncated if they are less than or greater than some defined fraction of
a quantile. The intent of winsorization is to limit the effect of extreme values.
}
\examples{
suppressPackageStartupMessages(library(dplyr))

len_out <- 25
by_unit <- "month"
start_date <- as.Date("2021-01-01")

data_tbl <- tibble(
  date_col = seq.Date(from = start_date, length.out = len_out, by = by_unit),
  a = rnorm(len_out),
  b = runif(len_out)
)

vec_1 <- hai_winsorized_truncate_vec(data_tbl$a, .fraction = 0.05)

plot(data_tbl$a)
lines(data_tbl$a)
lines(vec_1, col = "blue")

}
\seealso{
\url{https://en.wikipedia.org/wiki/Winsorizing}

This function can be used on it's own. It is also the basis for the function
\code{\link[=hai_winsorized_truncate_augment]{hai_winsorized_truncate_augment()}}.

Other Vector Function: 
\code{\link{hai_fourier_discrete_vec}()},
\code{\link{hai_fourier_vec}()},
\code{\link{hai_hyperbolic_vec}()},
\code{\link{hai_kurtosis_vec}()},
\code{\link{hai_scale_zero_one_vec}()},
\code{\link{hai_scale_zscore_vec}()},
\code{\link{hai_skewness_vec}()},
\code{\link{hai_winsorized_move_vec}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Vector Function}
