% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta-get-provider-data.R
\name{get_provider_meta_data}
\alias{get_provider_meta_data}
\title{Retrieve Provider Metadata from CMS}
\usage{
get_provider_meta_data(
  .identifier = NULL,
  .title = NULL,
  .description = NULL,
  .keyword = NULL,
  .issued = NULL,
  .modified = NULL,
  .released = NULL,
  .theme = NULL,
  .media_type = NULL
)
}
\arguments{
\item{.identifier}{A dataset identifier to filter the data.}

\item{.title}{A title to filter the data.}

\item{.description}{A description to filter the data.}

\item{.keyword}{A keyword to filter the data.}

\item{.issued}{A date when the dataset was issued to filter the data.}

\item{.modified}{A date when the dataset was modified to filter the data.}

\item{.released}{A date when the dataset was released to filter the data.}

\item{.theme}{A theme to filter the data.}

\item{.media_type}{A media type to filter the data.}
}
\value{
A tibble with metadata about the datasets.
}
\description{
This function sends a request to the specified CMS metadata URL, retrieves the JSON data,
and processes it to create a tibble with relevant information about the datasets.
}
\details{
The function fetches JSON data from the CMS metadata URL and extracts relevant fields to
create a tidy tibble. It selects specific columns, handles nested lists by unnesting them,
cleans column names, and processes dates and media types to make the data more useful for analysis.
The columns in the returned tibble are:
\itemize{
\item \code{identifier}
\item \code{title}
\item \code{description}
\item \code{keyword}
\item \code{issued}
\item \code{modified}
\item \code{released}
\item \code{theme}
\item \code{media_type}
\item \code{download_url}
\item \code{contact_fn}
\item \code{contact_email}
\item \code{publisher_name}
}
}
\examples{
library(dplyr)

# Fetch and process metadata from the CMS data URL
get_provider_meta_data(.identifier = "3614-1eef") |>
  glimpse()

}
\seealso{
\url{https://data.cms.gov/provider-data/api/1/metastore/schemas/dataset/items}

Other Meta Data: 
\code{\link{get_cms_meta_data}()}
}
\concept{Meta Data}
