% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fcst_sim.R
\name{ts_forecast_simulator}
\alias{ts_forecast_simulator}
\title{Time-series Forecasting Simulator}
\usage{
ts_forecast_simulator(
  .model,
  .horizon = 4,
  .iterations = 25,
  .sim_color = "steelblue",
  .alpha = 0.05,
  .data
)
}
\arguments{
\item{.model}{A forecasting model of one of the following from the \code{forecast} package:
\itemize{
\item \code{\link[forecast]{Arima}}
\item \code{\link[forecast]{auto.arima}}
\item \code{\link[forecast]{ets}}
\item \code{\link[forecast]{nnetar}}
}}

\item{.horizon}{An integer defining the forecast horizon.}

\item{.iterations}{An integer, set the number of iterations of the simulation.}

\item{.sim_color}{Set the color of the simulation paths lines.}

\item{.alpha}{Set the opacity level of the simulation path lines.}

\item{.data}{The data that is used for the \code{.model} parameter. This is used with
\code{\link[timetk:tk_index]{timetk::tk_index()}}}
}
\value{
The original time series, the simulated values and a some plots
}
\description{
Creating different forecast paths for forecast objects (when applicable),
by utilizing the underlying model distribution with the \code{\link[stats]{simulate}} function.
}
\details{
This function expects to take in a model of either \code{Arima},
\code{auto.arima}, \code{ets} or \code{nnetar} from the \code{forecast} package. You can supply a
forecasting horizon, iterations and a few other items.
}
\examples{
suppressPackageStartupMessages(library(forecast))
suppressPackageStartupMessages(library(healthyR.data))
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(timetk))
suppressPackageStartupMessages(library(ggplot2))
suppressPackageStartupMessages(library(plotly))
suppressPackageStartupMessages(library(purrr))
suppressPackageStartupMessages(library(tidyquant))
suppressPackageStartupMessages(library(tidyr))

data <- healthyR_data \%>\%
 filter(ip_op_flag == "I") \%>\%
   select(visit_end_date_time) \%>\%
   rename(date_col = visit_end_date_time) \%>\%
   summarise_by_time(
       .date_var = date_col
       , .by     = "month"
       , value   = n()
  ) \%>\%
   filter_by_time(
       .date_var     = date_col
       , .start_date = "2012"
       , .end_date   = "2019"
   )

data_ts <- tk_ts(data = data, frequency = 12)

# Create a model
fit <- auto.arima(data_ts)

# Simulate 50 possible forecast paths, with .horizon of 12 months
output <- ts_forecast_simulator(
  .model        = fit
  , .horizon    = 12
  , .iterations = 50
  , .data       = data
)

output$ggplot

output$plotly_plot

output$forecast_sim_tbl

output$input_data

output$sim_ts_tbl

output$forecast_sim

output$time_series


}
\author{
Steven P. Sanderson II, MPH
}
