% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boilerplate-lm.R
\name{ts_auto_lm}
\alias{ts_auto_lm}
\title{Boilerplate Workflow}
\usage{
ts_auto_lm(
  .data,
  .date_col,
  .value_col,
  .formula,
  .rsamp_obj,
  .prefix = "ts_lm",
  .bootstrap_final = FALSE
)
}
\arguments{
\item{.data}{The data being passed to the function. The time-series object.}

\item{.date_col}{The column that holds the datetime.}

\item{.value_col}{The column that has the value}

\item{.formula}{The formula that is passed to the recipe like \code{value ~ .}}

\item{.rsamp_obj}{The rsample splits object}

\item{.prefix}{Default is \code{ts_lm}}

\item{.bootstrap_final}{Not yet implemented.}
}
\value{
A list
}
\description{
This is a boilerplate function to create automatically the following:
\itemize{
\item recipe
\item model specification
\item workflow
\item calibration tibble and plot
}
}
\details{
This uses \code{parsnip::linear_reg()} and sets the \code{engine} to \code{lm}
}
\examples{
\dontrun{
library(dplyr)

data <- AirPassengers \%>\%
  ts_to_tbl() \%>\%
  select(-index)

splits <- time_series_split(
  data
  , date_col
  , assess = 12
  , skip = 3
  , cumulative = TRUE
)

ts_lm <- ts_auto_lm(
  .data = data,
  .date_col = date_col,
  .value_col = value,
  .rsamp_obj = splits,
  .formula = value ~ .,
)

ts_lm$recipe_info
}

}
\seealso{
\url{https://parsnip.tidymodels.org/reference/linear_reg.html}

Other Boiler_Plate: 
\code{\link{ts_auto_arima_xgboost}()},
\code{\link{ts_auto_arima}()},
\code{\link{ts_auto_croston}()},
\code{\link{ts_auto_exp_smoothing}()},
\code{\link{ts_auto_glmnet}()},
\code{\link{ts_auto_mars}()},
\code{\link{ts_auto_nnetar}()},
\code{\link{ts_auto_prophet_boost}()},
\code{\link{ts_auto_prophet_reg}()},
\code{\link{ts_auto_smooth_es}()},
\code{\link{ts_auto_svm_poly}()},
\code{\link{ts_auto_svm_rbf}()},
\code{\link{ts_auto_theta}()},
\code{\link{ts_auto_xgboost}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Boiler_Plate}
\concept{lm}
