% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boilerplate-theta.R
\name{ts_auto_theta}
\alias{ts_auto_theta}
\title{Boilerplate Workflow}
\usage{
ts_auto_theta(
  .data,
  .date_col,
  .value_col,
  .rsamp_obj,
  .prefix = "ts_theta",
  .bootstrap_final = FALSE
)
}
\arguments{
\item{.data}{The data being passed to the function. The time-series object.}

\item{.date_col}{The column that holds the datetime.}

\item{.value_col}{The column that has the value}

\item{.rsamp_obj}{The splits object}

\item{.prefix}{Default is \code{ts_theta}}

\item{.bootstrap_final}{Not yet implemented.}
}
\value{
A list
}
\description{
This is a boilerplate function to create automatically the following:
\itemize{
\item recipe
\item model specification
\item workflow
\item calibration tibble and plot
}
}
\details{
This uses the \code{forecast::thetaf()} for the \code{parsnip} engine. This
model does not use exogenous regressors, so only a univariate model of: value ~ date
will be used from the \code{.date_col} and \code{.value_col} that you provide.
}
\examples{
\donttest{
library(dplyr)
library(timetk)
library(modeltime)

data <- AirPassengers \%>\%
  ts_to_tbl() \%>\%
  select(-index)

splits <- time_series_split(
  data
  , date_col
  , assess = 12
  , skip = 3
  , cumulative = TRUE
)

ts_theta <- ts_auto_theta(
  .data = data,
  .date_col = date_col,
  .value_col = value,
  .rsamp_obj = splits
)

ts_theta$recipe_info
}
}
\seealso{
\url{https://business-science.github.io/modeltime/reference/exp_smoothing.html#engine-details}

\url{https://pkg.robjhyndman.com/forecast/reference/thetaf.html}

Other Boiler_Plate: 
\code{\link{ts_auto_arima_xgboost}()},
\code{\link{ts_auto_arima}()},
\code{\link{ts_auto_croston}()},
\code{\link{ts_auto_exp_smoothing}()},
\code{\link{ts_auto_glmnet}()},
\code{\link{ts_auto_lm}()},
\code{\link{ts_auto_mars}()},
\code{\link{ts_auto_nnetar}()},
\code{\link{ts_auto_prophet_boost}()},
\code{\link{ts_auto_prophet_reg}()},
\code{\link{ts_auto_smooth_es}()},
\code{\link{ts_auto_svm_poly}()},
\code{\link{ts_auto_svm_rbf}()},
\code{\link{ts_auto_xgboost}()}

Other exp_smoothing: 
\code{\link{ts_auto_croston}()},
\code{\link{ts_auto_exp_smoothing}()},
\code{\link{ts_auto_smooth_es}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Boiler_Plate}
\concept{exp_smoothing}
\concept{theta}
