% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.R
\name{get_probs_from_surv}
\alias{get_probs_from_surv}
\alias{get_probs_from_surv_}
\alias{get_probs_from_surv_.flexsurvreg}
\alias{get_probs_from_surv_.surv_dist}
\alias{get_probs_from_surv}
\title{Extract Transition Probabilities from a Survival Model}
\usage{
get_probs_from_surv_(x, ...)

\method{get_probs_from_surv_}{flexsurvreg}(x, cycle, km_limit = 0,
  cycle_length = 1, type = c("prob", "surv"), ...)

\method{get_probs_from_surv_}{surv_dist}(x, cycle, km_limit = 0,
  cycle_length = 1, type = c("prob", "surv"), ...)

get_probs_from_surv(x, ...)
}
\arguments{
\item{x}{Either a result from 
\code{\link[flexsurv]{flexsurvreg}} or
\code{\link{define_survival}}.}

\item{...}{arguments passed to methods.}

\item{cycle}{The \code{markov_cycle} or 
\code{state_time} for which to predict.}

\item{km_limit}{Up to what time should Kaplan-Meier 
estimates be used? Model predictions will be used 
thereafter. See \code{Details}.}

\item{cycle_length}{The value of a Markov cycle in 
absolute time units.}

\item{type}{either \code{prob}, for transition 
probabilities, or \code{surv}, for survival}
}
\value{
Returns the Markov transition probability for the
  cycles.
}
\description{
Get probabilities from survival models.
}
\details{
If \code{use_km_until = 0}, then only model probabilities
will be used.

The results of \code{get_probs_from_surv} are memoised for
\code{options("heemod.memotime")} (default: 1 hour) to
increase resampling performance.
}
