\name{gof.hergm}

\alias{gof.hergm}

\alias{hergm.gof}

\title{Goodness-of-fit}

\description{

The function \code{gof.hergm} accepts an \code{object} of class \code{hergm} as argument and assesses the goodness-of-fit of the model estimated by function \code{hergm}.

}

\usage{

\method{gof}{hergm}(object, \dots)

}

\arguments{

\item{object}{object of class \code{hergm}; objects of class \code{hergm} can be generated by function \code{hergm}.}

\item{\dots}{additional arguments, to be passed to lower-level functions in the future.}

}

\value{

The function \code{gof.hergm} returns a list with components:

\item{component.number}{number of components.}

\item{max.component.size}{size of largest component.}

\item{distance}{geodesic distance of pairs of nodes.}

\item{degree}{degree of nodes.}

\item{edges}{number of edges.}

\item{stars}{number of \code{2}-stars.}

\item{triangle}{number of triangles.}

}

\seealso{hergm, simulate.hergm}

\examples{
\dontrun{data(example)
object <- hergm(d ~ edges_ij + triangle_ijk)
gof(object)
}
}

