% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assemble.R, R/assemble.hero_bspline.R,
%   R/assemble.hero_radspline.R, R/assemble.list.R
\name{assemble}
\alias{assemble}
\alias{assemble.hero_bspline}
\alias{assemble.hero_radspline}
\alias{assemble.list}
\title{Assemble spline ingredients for sandwich smooth}
\usage{
assemble(object, ...)

\method{assemble}{hero_bspline}(object, x, m = 2, sparse = TRUE, ...)

\method{assemble}{hero_radspline}(object, x, m = 2, sparse = TRUE, spdiffpen = TRUE, digits = 1, ...)

\method{assemble}{list}(object, x, m = 2, sparse = TRUE, spdiffpen = TRUE, digits = 1, ...)
}
\arguments{
\item{object}{A spline-related object (e.g, a
\code{hero_bspline} from the \code{\link{bspline}}
function), or a list of spline-related objects.}

\item{...}{Not implemented}

\item{x}{Values at which to evaluate the basis functions.
This
should be a numeric vector if \code{object} is a
\code{hero_bspline}.  This should be a numeric matrix of
coordinates if \code{object} is a \code{hero_radspline}.
If \code{object} is a list comprised of
\code{hero_bspline} and \code{hero_radspline} objects,
then \code{x} should be a list where each element of the
list corresponds to the appropriate \code{x} argument
for each element.}

\item{m}{A positive integer indicating order of the difference penalty.}

\item{sparse}{A logical value indicating if the result
should be a sparse version of the
\code{\link[Matrix]{Matrix-class}}.}

\item{spdiffpen}{A logical value indicating whether
\code{\link{spdiffpen}} should be used to compute the
difference penalty.  The default is \code{FALSE}.}

\item{digits}{The number of digits to use when applying
\code{\link[base]{round}} to the distances.}
}
\value{
A list with the necessary components
  (ingredients)
}
\description{
Assemble computations from a spline-related object
\code{x} in order to implement the sandwich smoother.
This is essentially an internal function, but could be
useful for performing a manual implementation of the
sandwich smoother.
}
\examples{
# construct b-spline
object1 = bspline(nbasis = 10)
# sequence to evaluate
x1 = seq(0, 1, len = 11)
# assemble b-spline information
spline1 = assemble(object1, x1)

# assemble radial spline information
border = border.grid(lon, lat)
object2 = radspline(nknots = 16, border)
x2 = cbind(c(lon), c(lat))
spline2 = assemble(object2, x = x2)

# assemble for list of splines
object = list(object1, object2)
x = list(x1, x2)
splines = assemble(object, x)
}
