% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R, R/params_lm.R, R/params_mlogit.R,
%   R/params_mlogit_list.R, R/params_surv.R, R/params_surv_list.R
\name{create_params}
\alias{create_params}
\alias{create_params.lm}
\alias{create_params.multinom}
\alias{create_params.multinom_list}
\alias{create_params.flexsurvreg}
\alias{create_params.flexsurvreg_list}
\alias{create_params.partsurvfit}
\title{Create a parameter object from a fitted model}
\usage{
create_params(object, ...)

\method{create_params}{lm}(object, n = 1000, uncertainty = c("normal", "none"), ...)

\method{create_params}{multinom}(object, n = 1000, uncertainty = c("normal", "none"), ...)

\method{create_params}{multinom_list}(object, n = 1000, uncertainty = c("normal", "none"), ...)

\method{create_params}{flexsurvreg}(object, n = 1000, uncertainty = c("normal", "none"), ...)

\method{create_params}{flexsurvreg_list}(object, n = 1000, uncertainty = c("normal", "none"), ...)

\method{create_params}{partsurvfit}(
  object,
  n = 1000,
  uncertainty = c("normal", "bootstrap", "none"),
  max_errors = 0,
  silent = FALSE,
  ...
)
}
\arguments{
\item{object}{A statistical model to randomly sample parameters from.}

\item{...}{Currently unused.}

\item{n}{Number of random observations to draw. Not used if \code{uncertainty = "none"}.}

\item{uncertainty}{Method determining how parameter uncertainty should be handled.
If \code{"normal"}, then parameters are randomly drawn from their multivariate normal
distribution. If \code{"bootstrap"}, then parameters are bootstrapped using \code{\link{bootstrap}}.
If \code{"none"}, then only point estimates are returned.}

\item{max_errors}{Maximum number of errors that are allowed when fitting statistical models
during the bootstrap procedure. This argument may be useful if, for instance, the model
fails to converge during some bootstrap replications. Default is 0.}

\item{silent}{Logical indicating whether error messages should be suppressed. Passed to
the \code{silent} argument of \code{\link[=try]{try()}}.}
}
\value{
An object prefixed by \code{params_}. Mapping between \code{create_params}
and the classes of the returned objects are:
\itemize{
\item{\code{create_params.lm} ->}{ \code{\link{params_lm}}}
\item{\code{create_params.multinom} ->}{ \code{\link{params_mlogit}}}
\item{\code{create_params.multinom_list} ->}{ \code{\link{params_mlogit_list}}}
\item{\code{create_params.flexsurvreg} ->}{ \code{\link{params_surv}}}
\item{\code{create_params.flexsurvreg_list} ->}{ \code{\link{params_surv_list}}}
\item{\code{create_params.partsurvfit} ->}{ \code{\link{params_surv_list}}}
}
}
\description{
\code{create_params} is a generic function for creating an object containing
parameters from a fitted statistical model. If \code{uncertainty != "none"},
then random samples from suitable probability distributions are returned.
}
\examples{
# create_params.lm
fit <- lm(costs ~ female, data = psm4_exdata$costs$medical)
n <- 5
params_lm <- create_params(fit, n = n)
head(params_lm$coefs)
head(params_lm$sigma)

# create_params.flexsurvreg
library("flexsurv")
fit <- flexsurvreg(formula = Surv(futime, fustat) ~ 1, 
                   data = ovarian, dist = "weibull")
n <- 5
params_surv_wei <- create_params(fit, n = n)
print(params_surv_wei$dist)
head(params_surv_wei$coefs)
}
\seealso{
These methods are typically used alongside \code{\link[=create_input_mats]{create_input_mats()}}
to create model objects as a function of input data and a
fitted statistical model. For instance,
\code{\link[=create_PsmCurves]{create_PsmCurves()}} creates the survival model for a partitioned survival model,
\code{\link[=create_IndivCtstmTrans]{create_IndivCtstmTrans()}} creates the transition model for an individual
continuous time state transition model,
\code{\link[=create_CohortDtstmTrans]{create_CohortDtstmTrans()}} creates the transition model for a cohort discrete
time state transition model, and
\code{\link[=create_StateVals]{create_StateVals()}} creates a health state values model.
}
