% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hgwr.R
\name{print.hgwrm}
\alias{print.hgwrm}
\title{Print description of a \code{hgwrm} object.}
\usage{
\method{print}{hgwrm}(x, decimal.fmt = "\%.6f", ...)
}
\arguments{
\item{x}{An \code{hgwrm} object returned by \code{\link[=hgwr]{hgwr()}}.}

\item{decimal.fmt}{The format string passing to \code{\link[base:sprintf]{base::sprintf()}}.}

\item{...}{
  Arguments passed on to \code{\link[=print.table.md]{print.table.md}}
  \describe{
    \item{\code{col.sep}}{Column seperator. Default to \code{""}.}
    \item{\code{header.sep}}{Header seperator. Default to \code{"-"}.}
    \item{\code{row.begin}}{Character at the beginning of each row.
Default to \code{col.sep}.}
    \item{\code{row.end}}{Character at the ending of each row.
Default to \code{col.sep}.}
    \item{\code{table.style}}{Name of pre-defined style.
Possible values are \code{"plain"}, \code{"md"} or \code{"latex"}. Default to \code{"plain"}.}
  }}
}
\value{
No return.
}
\description{
Print description of a \code{hgwrm} object.
}
\examples{
data(multisampling)
model <- hgwr(formula = y ~ g1 + g2 + x1 + (z1 | group),
              data = multisampling$data,
              local.fixed = c("g1", "g2"),
              coords = multisampling$coord,
              bw = 10)
print(model)
print(model, table.style = "md")

}
\seealso{
\code{\link[=summary.hgwrm]{summary.hgwrm()}}, \code{\link[=print.table.md]{print.table.md()}}.
}
