% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C2pop.R
\name{stationary}
\alias{stationary}
\title{Stationary Distribution of a Transition Matrix}
\usage{
stationary(P)
}
\arguments{
\item{P}{a transition matrix, i.e., a square matrix where all rows sum to 1.}
}
\value{
the stationary probability vector.
}
\description{
This auxiliary function determines the stationary distribution
from a transition matrix.
}
\examples{
Cgrouped_norm <- contactmatrix(normalize = TRUE)
Cgrouped_norm
(p <- stationary(Cgrouped_norm))
(Cpowered <- make_powerC(Cgrouped_norm)(1e6))
stopifnot(all.equal(Cpowered[1,], p))
}
\author{
Leonhard Held
}
