% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster-position.R
\name{cluster_positions}
\alias{cluster_positions}
\title{Build Hierarchical Tree based on Position}
\usage{
cluster_positions(
  position,
  block = NULL,
  sort.parallel = TRUE,
  parallel = c("no", "multicore", "snow"),
  ncpus = 1L,
  cl = NULL
)
}
\arguments{
\item{position}{a data frame with two columns specifying the variable names
and the corresponding position or a list of data frames for multiple data
sets. The first column is required to contain the
variable names and to be of type character. The second column is required to
contain the position and to be of type numeric.}

\item{block}{a data frame or matrix specifying the second level of the
hierarchical tree. The first column is required to contain the
variable names and to be of type character. The second column is required to
contain the group assignment and to be a vector of type character or numeric.
If not supplied, the second level is built based on the
data.}

\item{sort.parallel}{a logical indicating whether the blocks should be sorted with respect to
the size of the block. This can reduce the run time for parallel computation.}

\item{parallel}{type of parallel computation to be used. See the 'Details' section.}

\item{ncpus}{number of processes to be run in parallel.}

\item{cl}{an optional \strong{parallel} or \strong{snow} cluster used if
\code{parallel = "snow"}. If not supplied, a cluster on the local machine is created.}
}
\value{
The returned value is an object of class \code{"hierD"},
consisting of two elements, the argument \code{"block"} and the
hierarchical tree \code{"res.tree"}.

The element \code{"block"} defines the second level of the hierarchical
tree if supplied.

The element \code{"res.tree"} contains a \code{\link{dendrogram}}
for each of the blocks defined in the argument \code{block}.
If the argument \code{block} is \code{NULL} (i.e. not supplied),
the element contains only one \code{\link{dendrogram}}.
}
\description{
Build a hierarchical tree based on the position of the variables.
}
\details{
The hierarchical tree is built based on recursive binary partitioning of
consecutive variables w.r.t. their position. The partitioning consists of
splitting a given node / cluster into two children of about equal size based
on the positions of the variables. If a node contains an odd number of
variables, then the variable in the middle w.r.t. position is assigned to
the cluster containing the closest neighbouring variable.
Hence, clusters at a given depth of the binary hierarchical tree contain
about the same number of variables.

If the argument \code{block} is supplied, i.e. the second level of the
hierarchical tree is given, the function can be run in parallel across
the different blocks by specifying the arguments \code{parallel} and
\code{ncpus}. There is an optional argument \code{cl} if
\code{parallel = "snow"}. There are three possibilities to set the
argument \code{parallel}: \code{parallel = "no"} for serial evaluation
(default), \code{parallel = "multicore"} for parallel evaluation
using forking, and \code{parallel = "snow"} for parallel evaluation
using a parallel socket cluster. It is recommended to select
\code{\link{RNGkind}("L'Ecuyer-CMRG")} and set a seed to ensure that
the parallel computing of the package \code{hierinf} is reproducible.
This way each processor gets a different substream of the pseudo random
number generator stream which makes the results reproducible if the arguments
(as \code{sort.parallel} and \code{ncpus}) remain unchanged. See the vignette
or the reference for more details.
}
\examples{
# The column names of the data frames position and block are optional.
position <- data.frame("var.name" = paste0("Var", 1:500),
                       "position" = seq(from = 1, to = 1000, by = 2))
dendr1 <- cluster_positions(position = position)

block <- data.frame("var.name" = paste0("Var", 1:500),
                    "block" = rep(c(1, 2), each = 250),
                    stringsAsFactors = FALSE)
dendr2 <- cluster_positions(position = position, block = block)


}
\references{
Renaux, C., Bühlmann, P. (2021), Efficient Multiple Testing 
Adjustment for Hierarchical Inference. <arXiv:2104.15028>
}
\seealso{
\code{\link{cluster_vars}}, \code{\link{advance_hierarchy}}, 
and \code{\link{run_hierarchy}}.
}
