% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-hc.R
\name{hc_exporting}
\alias{hc_exporting}
\title{Setting exporting options for highcharts objects}
\usage{
hc_exporting(hc, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{...}{Arguments defined in \url{http://api.highcharts.com/highcharts/exporting}.}
}
\description{
Exporting options for highcharts objects. You can define the file's name
or the output format.
}
\examples{

require("dplyr")

data("citytemp")

highchart() \%>\% 
  hc_xAxis(categories = citytemp$month) \%>\% 
  hc_add_series(name = "Tokyo", data = citytemp$tokyo) \%>\% 
  hc_add_series(name = "London", data = citytemp$london) \%>\% 
  hc_exporting(enabled = TRUE,
               filename = "custom-file-name")

}
