% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hb_metrics.R
\name{hb_metrics}
\alias{hb_metrics}
\title{Borrowing metrics}
\usage{
hb_metrics(borrow, pool, independent)
}
\arguments{
\item{borrow}{A data frame returned by \code{\link[=hb_summary]{hb_summary()}}
for a borrowing model,
either the hierarchical model or the mixture model.}

\item{pool}{A data frame returned by \code{\link[=hb_summary]{hb_summary()}}
for the pooled model.}

\item{independent}{A data frame returned by \code{\link[=hb_summary]{hb_summary()}}
for the independent model.}
}
\value{
A data frame with borrowing metrics.
}
\description{
Calculate historical borrowing metrics using
summary output from a fitted borrowing model and
analogous summaries from the benchmark models.
}
\examples{
if (!identical(Sys.getenv("HB_TEST", unset = ""), "")) {
data <- hb_sim_independent(n_continuous = 2)$data
mcmc_borrow <- hb_mcmc_hierarchical(
  data,
  n_chains = 1,
  n_adapt = 100,
  n_warmup = 100,
  n_iterations = 200
)
mcmc_pool <- hb_mcmc_pool(
  data,
  n_chains = 1,
  n_adapt = 100,
  n_warmup = 50,
  n_iterations = 50
)
mcmc_independent <- hb_mcmc_independent(
  data,
  n_chains = 1,
  n_adapt = 100,
  n_warmup = 50,
  n_iterations = 50
)
borrow <- hb_summary(mcmc_borrow, data)
pool <- hb_summary(mcmc_pool, data)
independent <- hb_summary(mcmc_independent, data)
hb_metrics(
  borrow = borrow,
  pool = pool,
  independent = independent
)
}
}
\seealso{
Other summary: 
\code{\link{hb_summary}()}
}
\concept{summary}
