% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extrapol.gev.R
\name{extrapol.gev}
\alias{extrapol.gev}
\title{Spatial extrapolation of GEV parameters with the HKEVP}
\usage{
extrapol.gev(fit, targets, targets.covariates)
}
\arguments{
\item{fit}{Output from the \code{hkevp.fit} procedure.}

\item{targets}{A matrix of real values giving the spatial coordinates of the ungauged positions. Each row corresponds to an ungauged position.}

\item{targets.covariates}{A matrix of real values giving the spatial covariates of the ungauged positions. Must match with the covariates used in \code{\link{hkevp.fit}} or \code{\link{latent.fit}}.}
}
\value{
A named list of three elements: \code{loc}, \code{scale}, \code{shape}. Each one is a matrix with columns corresponding to targets positions.
}
\description{
Predictive distributions of the GEV parameters at a set of ungauged sites (targets), given the output from the MCMC procedures \code{hkevp.fit} or \code{latent.fit}. See details.
}
\details{
Since the GEV parameters are modelled with latent Gaussian processes, spatial extrapolation of the marginal distributions at target positions \eqn{(s^*_1, ..., s^*_k)} is performed with simple kriging. Estimation is done at each MCMC step to produce a sample of the predictive distribution.
}
\examples{
\donttest{
# Simulation of HKEVP:
sites <- as.matrix(expand.grid(1:3,1:3))
loc <- sites[,1]*10
scale <- 3
shape <- 0
alpha <- .4
tau <- 1
ysim <- hkevp.rand(10, sites, sites, loc, scale, shape, alpha, tau)

# HKEVP fit:
fit <- hkevp.fit(ysim, sites, niter = 1000)

## Extrapolation:
targets <- matrix(1.5, 1, 2)
gev.targets <- extrapol.gev(fit, targets)

## True vs predicted:
predicted <- sapply(gev.targets, median)
sd.predict <- sapply(gev.targets, sd)
true <- c(targets[,1]*10, scale, shape)
# cbind(true, predicted, sd.predict)
}

}
\seealso{
\code{\link{extrapol.return.level}}
}
\author{
Quentin Sebille
}
