% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{OddsRatio}
\alias{OddsRatio}
\title{Compute item pairwise odds ratio}
\usage{
OddsRatio(N, J, Yt)
}
\arguments{
\item{N}{An \code{int} of the sample size}

\item{J}{An \code{int} of the number of items}

\item{Yt}{An N-by-J response \code{matrix}}
}
\value{
A J-by-J upper-triangular \code{matrix} of the item pairwise odds ratios
}
\description{
Based on a response matrix, calculate the item pairwise odds-ratio according do (n11\emph{n00)/(n10}n01), where nij is the
number of people answering both item i and item j correctly
}
\examples{
\donttest{
N = dim(Y_real_array)[1]
J = nrow(Q_matrix)
OddsRatio(N,J,Y_real_array[,,1])}
}
