% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{validation_diagnostics}
\alias{validation_diagnostics}
\title{Emulator Diagnostics}
\usage{
validation_diagnostics(
  emulators,
  targets = NULL,
  validation = NULL,
  which_diag = c("cd", "ce", "se"),
  analyze = TRUE,
  diagnose = "expectation",
  ...
)
}
\arguments{
\item{emulators}{A list of \code{\link{Emulator}} objects.}

\item{targets}{The list of observations for the outputs}

\item{validation}{The validation set, containing all inputs and outputs.}

\item{which_diag}{Which diagnostics should be performed (see description)}

\item{analyze}{Should plotting and/or failing points be returned?}

\item{diagnose}{For bimodal systems, should the expectation or variance be considered?}

\item{...}{Any additional parameters to pass to the diagnostics (eg sd, cutoff, ...)}
}
\value{
A data.frame containing points that failed one or more diagnostic tests.
}
\description{
Performs the standard set of validation diagnostics on emulators.
}
\details{
All the diagnostics here can be performed with or without a validation (or `holdout')
set of data. The presence of a set of targets is optional for some checks but
mandatory for others: the appropriate warnings will be given in the event that some
checks cannot be applied.

The current options for diagnostics (with the codes for \code{which_diag}) are:

  Standardised Errors (se)

  Comparison Diagnostics (cd)

  Classification Errors (ce)

  All of the above (all)

For details of each of the tests, see the help file for
\code{\link{get_diagnostic}}.
}
\examples{
validation_diagnostics(SIREmulators$ems, SIREmulators$targets, SIRSample$validation)
# data.frame of failed points (empty) and a 3x3 set of plots
validation_diagnostics(SIREmulators$ems, SIREmulators$targets, SIRSample$validation,
 c('ce','cd'))
# empty data.frame and a 3x2 set of plots
validation_diagnostics(SIREmulators$ems, SIREmulators$targets, SIRSample$validation,
 cutoff = 2, sd = 2)
# k-fold (with k = 3)
validation_diagnostics(SIREmulators$ems, SIREmulators$targets, k = 3)
}
\seealso{
Other diagnostic functions: 
\code{\link{analyze_diagnostic}()},
\code{\link{classification_diag}()},
\code{\link{comparison_diag}()},
\code{\link{get_diagnostic}()},
\code{\link{individual_errors}()},
\code{\link{residual_diag}()},
\code{\link{standard_errors}()},
\code{\link{summary_diag}()}
}
\concept{diagnostic functions}
