% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_imp_roundedcont_2017-01-31.R
\name{imp_roundedcont}
\alias{imp_roundedcont}
\title{The function to impute rounded continuous variables}
\usage{
imp_roundedcont(y_imp_multi, X_imp_multi, intercept_varname = NULL, M)
}
\arguments{
\item{y_imp_multi}{A Vector with the variable to impute.}

\item{X_imp_multi}{A data.frame with the fixed effects variables.}

\item{intercept_varname}{A character denoting the name of the intercept variable.}

\item{M}{An integer defining the number of imputations that should be made.}
}
\value{
A n x M matrix. Each column is one of M imputed y-variables.
}
\description{
For example the income in surveys is often reported rounded by the respondents.
See Drechsler, Kiesl and Speidel (2015) for more details.
}
\references{
Joerg Drechsler, Hans Kiesl, Matthias Speidel (2015):
"MI Double Feature: Multiple Imputation to Address Nonresponse and Rounding Errors in Income Questions".
Austrian Journal of Statistics Vol. 44, No. 2, http://dx.doi.org/10.17713/ajs.v44i2.77
}
