% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_smallfunctions_2018-05-31.R
\name{extract_varnames}
\alias{extract_varnames}
\title{Function to extract the different elements of a formula}
\usage{
extract_varnames(model_formula = NULL, constant_variables,
  variable_names_in_data, data)
}
\arguments{
\item{model_formula}{A formula (from class \code{formula})}

\item{constant_variables}{A Boolean-vector of length equal to the number of columns in the data set
specifying whether a variable is a constant variable (eg. an intercept variable) or not.}

\item{variable_names_in_data}{A character-vector with the column names of the data set.}

\item{data}{The data.frame the formula belongs to.}
}
\value{
A list with the names of the target variable, the intercept variable,
the fixed and random effects covariates (which includes the name of the target variable),
the variables with interactions and the cluster id variable.\cr
If some of them don't exist, they get the value "".
}
\description{
The function searches for the target variable, fixed effects variables,
if there is a cluster ID: this and the random effects variables.\cr
The names of the fixed and random intercepts variable (if existent) are explicitly labeled
In imputation models, the target variable can act as covariate
for other covariates - so we treat the target variable as fix effect variable.
}
