% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{bic}
\alias{bic}
\title{BIC
Bayesian Information Criterion for the HMM}
\usage{
bic(hmm)
}
\arguments{
\item{hmm}{an object of class "\code{mhmm}" or "\code{fhmm}", a result of a call to \code{\link{fitBM_mhmm}} or \code{\link{fitBM_fhmm}}}
}
\value{
The function returns the value corresponding to the BIC for a HMM.
}
\description{
BIC
Bayesian Information Criterion for the HMM
}
\examples{
data(copulahmmdata)
Obs <- copulahmmdata
n <- 20 #number of statistical units
n_tot <- 5000 #total number of observations
bt <- seq(1, n_tot, by = n)
distr <- c("exp", "gaussian")
#Initialize the HMM
parameters <- list(as.matrix(c(1,0.25)), matrix(c(3, -1, 1, 1), nrow = 2))
corr <- array(c(1, 0.4, 0.4, 1, 1, 0.1, 0.1, 1), dim = c(2, 2, 2))
hmm <- set_mhmm(Obs, bT = bt, nStates = 2, params = parameters, corr = corr, distr = distr)
# Compute the parameters of the HMM with the Baum-Welch algorithm
bw <- fitBM_mhmm(hmm)

BIC <- bic(bw)
}
\references{
Martino A., Guatteri, G. and Paganoni A. M., Multivariate Hidden Markov Models for disease progression, Mox Report 59/2018, 2018
Martino A., Guatteri, G. and Paganoni A. M., Hidden Markov Models for multivariate functional data, MOX Report 21/2019, 2019
}
\seealso{
\code{\link{aic}}, \code{\link{fitBM_fhmm}}, \code{\link{fitBM_mhmm}}
}
