% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copulafunctions.R
\name{rmdistr}
\alias{rmdistr}
\title{Random generator Function for multivariate data}
\usage{
rmdistr(n, params, corr, distr)
}
\arguments{
\item{n}{the length of the sample}

\item{params}{a list of D elements corresponding to the   matrices corresponding to the parameters:}

\item{corr}{a matrix containing the correlation parameters of the multivariate distribution related to the states of the HMM;}

\item{distr}{a vector containing the distribution for each component, "gaussian" for the normal distribution, "gamma" for the gamma distribution, "exp" for the exponential distribution}
}
\value{
The function returns a n x d matrix
}
\description{
This function generates the values of a multivariate distribution with given marginals and correlation matrix
}
\examples{
#Simulate a bivariate sample with a gaussian component and an exponential one
n <- 100
params <- list(t(c(1,1)), as.matrix(1))
corr <- cbind(c(1,0.5), c(0.5,1))
distr <- c("gaussian", "exp")

x <- rmdistr(n = n, params = params, corr = corr, distr = distr)
}
\references{
Song, P. X.-K.(2000). Multivariate dispersion models generated from Gaussian copula. Scandinavian Journal of Statistics, 27(2), 305-320.
}
