% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprouting_condition.R
\name{sc_max_metric}
\alias{sc_max_metric}
\title{Default sprouting condition based on given metric.}
\usage{
sc_max_metric(metric, max_distances)
}
\arguments{
\item{metric}{\itemize{
\item Metric used for deme distance comparison (e.g.
euclidean_distance, manhattan_distance)
}}

\item{max_distances}{\itemize{
\item numeric - maximum distance to a sprout of
a deme on the target level that would allow the idividual to sprout
}}
}
\value{
Function that can be used as a sprouting condition of hms.
}
\description{
It allows an individual to sprout only if there are no other
demes on the target level that have sprouted within the given
distance.
}
\examples{
sprouting_condition <- sc_max_metric(euclidean_distance, c(20, 10))
}
