% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emissions.R
\name{plot_emissions_with_land}
\alias{plot_emissions_with_land}
\title{Download and plot essential climate data}
\usage{
plot_emissions_with_land(
  dataset = get_emissions(),
  start_year = 1900,
  region = "World",
  print = TRUE,
  annot = TRUE,
  title_expression = expression("Fossil + Land Use Change " * CO[2] * " Emissions"),
  yaxis_expression = expression("Gt " * CO[2] * " per year")
)
}
\arguments{
\item{dataset}{Name of the tibble generated by \code{get_emissions}}

\item{start_year}{Year to start plot at. Defaults to 1900. Data is available since 1750.}

\item{region}{ISO code of region to plot. Defaults to 'OWID_WRL' which signifies entire world.}

\item{print}{(boolean) Display carbon dioxide emissions ggplot2 chart, defaults to TRUE. Use FALSE to not display chart.}

\item{annot}{(boolean) Include chart annotation with latest date and value, defaults to TRUE.}

\item{title_expression}{Chart title, defaults to CO2 emissions}

\item{yaxis_expression}{y-axis label, defaults to Gt CO2 emissions}
}
\value{
Invisibly returns a ggplot2 object with carbon dioxide emissions chart
}
\description{
Plots carbon dioxide emissions (including land use change) retrieved using \code{get_emissions()} with ggplot2. The output ggplot2 object may be modified. Alternative columns from the dataset may also be plotted.
}
\details{
\code{plot_emissions_with_land} invisibly returns a ggplot2 object with a pre-defined carbon dioxide emissions (including land use change) chart using data from \code{get_emissions}.
By default the chart is also displayed. Users may further modify the output ggplot2 chart.
}
\examples{
\donttest{
# Fetch carbon dioxide emissions:
emissions <- get_emissions()

# Plot output (including land use change) using package's built-in ggplot2 defaults
plot_emissions_with_land(emissions)

# Or just call plot_emissions_with_land(), which defaults to get_emissions() dataset
plot_emissions_with_land()

# You can also select a region by name and starting year
plot_emissions_with_land(region='United States', start_year=1950)
p <- plot_emissions_with_land(emissions, print = FALSE)

# Modify plot such as: p + ggplot2::labs(title='Anthropogenic Carbon Emissions')}


}
\author{
Hernando Cortina, \email{hch@alum.mit.edu}
}
