% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurricanes.R
\name{plot_hurricanes}
\alias{plot_hurricanes}
\title{Download and plot essential climate data}
\usage{
plot_hurricanes(dataset = get_hurricanes(), cat = "major", print = TRUE)
}
\arguments{
\item{dataset}{Name of the tibble generated by \code{get_hurricanes}}

\item{cat}{(string) Select which category of hurricane to plot. May be "major", "hurricane", or "storm". Defaults to "major".}

\item{print}{(boolean) Display hurricane ggplot2 chart, defaults to TRUE. Use FALSE to not display chart.}
}
\value{
Invisibly returns a ggplot2 object with hurricanes chart
}
\description{
Plots the hurricane data retrieved using \code{get_hurricanes()} with ggplot2. The output ggplot2 object may be further modified.
}
\details{
\code{plot_hurricanes} invisibly returns a ggplot2 object with a pre-defined hurricane data chart using data from \code{get_hurricanes}.
By default the chart is also displayed. Smooths using ggplot2's built-in loess smoother. Users may further modify the output ggplot2 chart.
Categories may be "major" (category 3-5), "hurricane" (category 1-5), or "storm" (named storm).
}
\examples{
\donttest{
# Fetch hurricane data:
hurricanes <- get_hurricanes()
#
# Plot output using package's built-in ggplot2 defaults
plot_hurricanes(hurricanes)

# Or just call plot_hurricanes(), which defaults to get_hurricanes() dataset
plot_hurricanes()

p <- plot_hurricanes(hurricanes, print = FALSE)
# Modify plot such as: p + ggplot2::labs(title='Growing number of North Atlantic named storms') }

}
\author{
Hernando Cortina, \email{hch@alum.mit.edu}
}
