% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bowling_basics.R
\name{bowl_econ}
\alias{bowl_econ}
\title{Bowler Economy Rate}
\usage{
bowl_econ(balls_bowled, runs_conceded, type = "overs")
}
\arguments{
\item{balls_bowled}{number of balls bowled. Data in terms of six ball overs,
please convert to \code{\link{overs_to_balls}} to get it terms of \verb{balls bowled}}

\item{runs_conceded}{total runs conceded by bowler across the overs, sets or per hundred balls bowled.}

\item{type}{whether we are calculating economy over six ball overs, sets or per hundred balls bowled.
Options "overs", "sets", "per_100". Defaults to overs}
}
\value{
Economy rate across the number of overs, sets or per hundred balls bowled.
}
\description{
Calculates bowlers' economy rate over six ball overs, five ball sets or per hundred balls.
}
\section{Additional Information}{

Bowling economy rate is average number of runs scored per over or sets bowled.
\itemize{
\item If using overs, a value of 9.5 indicates an average of 9.5 runs are scored per six ball over bowled.
\item If using sets, a value of 9.5 indicates an average of 9.5 runs are scored per five ball set bowled.
\item If using here, a value of 9.5 indicates an average of 9.5 runs are scored per hundred balls bowled.
This the official statistic used by \href{https://www.thehundred.com/stats?stat=econRatePerHundred&type=men&year=2022}{The Hundred.} \cr
\cr
The higher the number the more detrimental is for the bowler. Runs scored through byes & leg byes are \strong{excluded} from runs conceded by the bowler,
however wides and no-balls are \strong{included} in the bowler's figures. \cr
More info \href{https://en.wikipedia.org/wiki/Economy_rate}{here.}
}
}

\examples{
bowl_econ(balls_bowled = 60, runs_conceded = 45)
bowl_econ(
  balls_bowled = overs_to_balls(overs = 7.1),
  runs_conceded = 26,
  type = "overs"
)

bowl_econ(balls_bowled = 30, runs_conceded = 35, type = "sets")

bowl_econ(balls_bowled = 22, runs_conceded = 19, type = "per_100")

}
