% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{hsaDist}
\alias{hsaDist}
\alias{dhsa}
\alias{ehsa}
\title{Probabilities and Moments Hermite Spline Approximation}
\usage{
dhsa(x, m, knots, mean = 0, sd = 1, log = FALSE)

ehsa(m, knots, mean = 0, sd = 1, power = 1)
}
\arguments{
\item{x}{numeric vector of values for which the function should 
be estimated.}

\item{m}{numeric matrix which rows correspond to spline intervals
while columns represent variables powers. Therefore the element 
in i-th row and j-th column represents the coefficient associated with
the variable that 1) belongs to the i-th interval i.e. between i-th and
(i + 1)-th knots 2) raised to the power of (j - 1).}

\item{knots}{sorted in ascending order numeric vector representing
knots of the spline.}

\item{mean}{expected value of a normal distribution.}

\item{sd}{standard deviation of a normal distribution.}

\item{log}{logical; if \code{TRUE} then probabilities p are given as log(p)
or derivatives will be given respect to log(p).}

\item{power}{non-negative integer representing the power of the 
expected value i.e. E(X ^ power) will be estimated.}
}
\value{
Function \code{\link[hpa]{dhsa}} returns vector of probabilities
of the same length as \code{x}. Function \code{\link[hpa]{ehsa}} 
returns moment value.
}
\description{
The set of functions similar to \code{\link[hpa]{dhpa}}-like
functions. The difference is that instead of polynomial these functions
utilize spline.
}
\details{
In contrast to \code{\link[hpa]{dhpa}}-like functions these
functions may deal with univariate distributions only. In future this
functions will be generalized to work with multivariate distributions.
The main idea of these functions is to use squared spline instead of squared 
polynomial in order to provide greater numeric stability and approximation 
accuracy. To provide spline parameters please use \code{m} and \code{knots}
arguments (i.e. instead of \code{pol_degrees} and \code{pol_coefficients}
arguments that where used to specify the polynomial
for \code{\link[hpa]{dhpa}}-like functions).
}
\examples{
## Examples demonstrating dhsa and ehsa functions application.

# Generate a b-splines
b <- bsplineGenerate(knots = c(-2.1, 1.5, 1.5, 2.2, 3.7, 4.2, 5),
                     degree = 3)
                      
# Combine b-splines into a spline
spline <- bsplineComb(splines = b, weights = c(1.6, -1.2, 3.2))

# Assign parameters using the spline created above
knots <- spline$knots
m <- spline$m
mean <- 1
sd <- 2

# Estimate the density at particular points
x <- c(2, 3.7, 8)
dhsa(x, 
     m = m, knots = knots,
     mean = mean, sd = sd)
     
# Calculate expected value
ehsa(m = m, knots = knots,
     mean = mean, sd = sd,
     power = 1) 
     
# Evaluate the third moment
ehsa(m = m, knots = knots,
     mean = mean, sd = sd,
     power = 3) 
}
\seealso{
\code{\link[hpa]{dhpa}}, \code{\link[hpa]{bsplineGenerate}}
}
