% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcKFoldError.R
\name{calcKFoldError}
\alias{calcKFoldError}
\title{Calculate index error with FKold (out of sample)}
\usage{
calcKFoldError(hpi_obj, pred_df, k = 10, seed = 1, smooth = FALSE, ...)
}
\arguments{
\item{hpi_obj}{HPI object of class 'hpi'}

\item{pred_df}{Data.frame of sales to be used for assessing predictive quality of index}

\item{k}{default=10; Number of folds to apply to holdout process}

\item{seed}{default=1; Random seed generator to control the folding process}

\item{smooth}{default = FALSE; Calculate on the smoothed index}

\item{...}{Additional Arguments}
}
\value{
object of class `hpiaccuracy` inheriting from class `data.frame` containing the
following fields:
\describe{
  \item{prop_id}{Property Identification number}
  \item{pred_price}{Predicted price}
  \item{pred_error}{(Prediction - Actual) / Actual}
  \item{pred_period}{Period of the prediction}
}
}
\description{
Use a KFold (out of sample) approach to estimate index accuracy
}
\examples{

 # Load data
 data(ex_sales)

 # Create index with raw transaction data
 rt_index <- rtIndex(trans_df = ex_sales,
                     periodicity = 'monthly',
                     min_date = '2010-06-01',
                     max_date = '2015-11-30',
                     adj_type = 'clip',
                     date = 'sale_date',
                     price = 'sale_price',
                     trans_id = 'sale_id',
                     prop_id = 'pinx',
                     estimator = 'robust',
                     log_dep = TRUE,
                     trim_model = TRUE,
                     max_period = 48,
                     smooth = FALSE)

  # Create prediction data
  rt_data <- rtCreateTrans(trans_df = ex_sales,
                          prop_id = 'pinx',
                          trans_id = 'sale_id',
                          price = 'sale_price',
                          periodicity = 'monthly',
                          date = 'sale_date')

  # Calc Accuracy
  kf_accr <- calcKFoldError(hpi_obj = rt_index,
                            pred_df = rt_data,
                            k = 10,
                            seed = 123,
                            smooth = FALSE)

}
