% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcAccuracy.R
\name{calcSeriesAccuracy}
\alias{calcSeriesAccuracy}
\title{Calculate the accuracy of a series of indexes}
\usage{
calcSeriesAccuracy(series_obj, test_method = "insample", test_type = "rt",
  pred_df = NULL, smooth = FALSE, summarize = FALSE, in_place = FALSE,
  in_place_name = "accuracy", ...)
}
\arguments{
\item{series_obj}{Serieshpi object to be analyzed}

\item{test_method}{default = 'insample'; Also 'kfold' or 'forecast'}

\item{test_type}{default = 'rt'; Type of data to use for test.  See details.}

\item{pred_df}{default = NULL; Extra data if the test_type doesn't match data in hpi_obj}

\item{smooth}{default = FALSE; Analyze the smoothed indexes}

\item{summarize}{default = FALSE; When multiple accuracy measurements for single observation
take the mean of them all.}

\item{in_place}{default = FALSE; Should the result be returned into an existing `hpi` object}

\item{in_place_name}{default = 'accuracy'; Name for returning in place}

\item{...}{Additional Arguments}
}
\value{
`seriesaccuracy` object (unless calculated 'in_place')
}
\description{
Estimate the index accuracy for a (progressive) series of indexes
}
\section{Further Details}{

Unless using `test_method = "forecast"`` with a "forecast_length" of 1, the results
will have more than one accuracy estimate per observations.  Setting `summarize = TRUE`
will take the mean accuracy for each observation across all indexes.
}

\examples{

 # Load data
 data(ex_sales)

 # Create index
 rt_index <- rtIndex(trans_df = ex_sales,
                     periodicity = 'monthly',
                     min_date = '2010-06-01',
                     max_date = '2015-11-30',
                     adj_type = 'clip',
                     date = 'sale_date',
                     price = 'sale_price',
                     trans_id = 'sale_id',
                     prop_id = 'pinx',
                     estimator = 'robust',
                     log_dep = TRUE,
                     trim_model = TRUE,
                     max_period = 48,
                     smooth = FALSE)

  #  Create Series (Suppressing messages do to small sample size of this example)
  suppressMessages(
    hpi_series <- createSeries(hpi_obj = rt_index,
                               train_period = 12))

  # Calculate insample accuracy
  hpi_series_accr <- calcSeriesAccuracy(series_obj = hpi_series,
                                        test_type = 'rt',
                                        test_method = 'insample')

}
