% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HRdata.r
\docType{data}
\name{hrData}
\alias{hrData}
\title{A simulated data set}
\format{
An object of class \code{"data.frame"}.
}
\usage{
data(hrData)
}
\description{
A simulated cohort with 9 confounders (X1 to X9), generated with the algorithm described in Hajage *et al.* (2018) \doi{10.1002/bimj.201700330}.
}
\examples{
data(hrData, package = "hrIPW")
hrIPW(hrData, time = "time", status = "status", exposure = "Trt",
      variables = paste("X", 1:9, sep = ""), wtype = "ATE-stab")
}
\references{
Closed-form variance estimator for weighted propensity score estimators with survival outcome.
  Submitted to Statistics in Medicine (2017).
}
\keyword{datasets}
