% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.r
\name{scale_x_percent}
\alias{scale_x_percent}
\alias{scale_y_percent}
\alias{scale_x_comma}
\alias{scale_y_comma}
\title{X & Y scales with opinionated pre-sets for percent & comma label formats}
\usage{
scale_x_percent(
  name = waiver(),
  breaks = waiver(),
  minor_breaks = waiver(),
  guide = waiver(),
  n.breaks = NULL,
  labels,
  limits = NULL,
  expand = c(0.01, 0),
  oob = censor,
  na.value = NA_real_,
  trans = "identity",
  position = "bottom",
  sec.axis = waiver(),
  accuracy = 1,
  scale = 100,
  prefix = "",
  suffix = "\%",
  big.mark = " ",
  decimal.mark = ".",
  trim = TRUE,
  ...
)

scale_y_percent(
  name = waiver(),
  breaks = waiver(),
  minor_breaks = waiver(),
  guide = waiver(),
  n.breaks = NULL,
  labels,
  limits = NULL,
  expand = c(0.01, 0),
  oob = censor,
  na.value = NA_real_,
  trans = "identity",
  position = "left",
  sec.axis = waiver(),
  accuracy = 1,
  scale = 100,
  prefix = "",
  suffix = "\%",
  big.mark = " ",
  decimal.mark = ".",
  trim = TRUE,
  ...
)

scale_x_comma(
  name = waiver(),
  breaks = waiver(),
  minor_breaks = waiver(),
  guide = waiver(),
  n.breaks = NULL,
  labels,
  limits = NULL,
  expand = c(0.01, 0),
  oob = censor,
  na.value = NA_real_,
  trans = "identity",
  position = "bottom",
  sec.axis = waiver(),
  accuracy = 1,
  scale = 1,
  prefix = "",
  suffix = "",
  big.mark = ",",
  decimal.mark = ".",
  trim = TRUE,
  ...
)

scale_y_comma(
  name = waiver(),
  breaks = waiver(),
  minor_breaks = waiver(),
  guide = waiver(),
  n.breaks = NULL,
  labels,
  limits = NULL,
  expand = c(0.01, 0),
  oob = censor,
  na.value = NA_real_,
  trans = "identity",
  position = "left",
  sec.axis = waiver(),
  accuracy = 1,
  scale = 1,
  prefix = "",
  suffix = "",
  big.mark = ",",
  decimal.mark = ".",
  trim = TRUE,
  ...
)
}
\arguments{
\item{name}{The name of the scale. Used as axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
transformation object
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output
}}

\item{minor_breaks}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (one minor break between
each major break)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks.
}}

\item{guide}{guide    A function used to create a guide or its name. See \code{\link[=guides]{guides()}} for more information.}

\item{n.breaks}{An integer guiding the number of major breaks. The algorithm may choose a
slightly different number to ensure nice break labels. Will only have an effect if
\code{breaks = waiver()}. Use NULL to use the default number of breaks given by the transformation.}

\item{labels}{Specifying overrides the default format (i.e. you really don't
want to do that). \code{NULL} means no labels.}

\item{limits}{A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum.}

\item{expand}{same as in ggplot2}

\item{oob}{Function that handles limits outside of the scale limits
(out of bounds). The default replaces out of bounds values with NA.}

\item{na.value}{If \code{na.translate = TRUE}, what value aesthetic
value should missing be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}

\item{trans}{Either the name of a transformation object, or the
object itself. Built-in transformations include "asn", "atanh",
"boxcox", "exp", "identity", "log", "log10", "log1p", "log2",
"logit", "probability", "probit", "reciprocal", "reverse" and "sqrt".}

\item{position}{The position of the axis. "left" or "right" for vertical
scales, "top" or "bottom" for horizontal scales}

\item{sec.axis}{specify a secondary axis}

\item{accuracy, scale, prefix, suffix, big.mark, decimal.mark, trim}{See
[scales::comma_format()] or [scales::percent_format()]}

\item{...}{passed on to [scales::comma_format()] or [scales::percent_format()]}
}
\description{
The \verb{_comma} ones set comma format for axis text and \code{expand=c(0,0)} (you need to set limits).
}
\details{
The \verb{_percent} ones set precent format for axis text and \code{expand=c(0,0)} (you need to set limits).
}
