% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{editraw}
\alias{editraw}
\title{Editing results of hsrecombi}
\usage{
editraw(Roh, map1)
}
\arguments{
\item{Roh}{list of raw results from \code{hsrecombi}}

\item{map1}{data.frame containing information on physical map, at least:
\describe{
 \item{\code{SNP}}{SNP ID}
 \item{\code{locus_Mb}}{physical position in Mbp of SNP on chromosomes}
 \item{\code{Chr}}{chromosome of SNP}
}}
}
\value{
final table of results
\describe{
  \item{\code{SNP1}}{index 1. SNP}
  \item{\code{SNP2}}{index 2. SNP}
  \item{\code{D}}{maternal LD}
  \item{\code{fAA}}{frequency of maternal haplotype 1-1}
  \item{\code{fAB}}{frequency of maternal haplotype 1-0}
  \item{\code{fBA}}{frequency of maternal haplotype 0-1}
  \item{\code{fBB}}{frequency of maternal haplotype 0-0}
  \item{\code{p1}}{Maternal allele frequency (allele 1) SNP1}
  \item{\code{p2}}{Maternal allele frequency (allele 1) SNP2}
  \item{\code{nfam1}}{size of genomic family 1}
  \item{\code{nfam2}}{size of genomic family 2}
  \item{\code{error}}{0 if computations were without error; 1 if EM algorithm
    did not converge}
  \item{\code{iteration}}{number of EM iterations}
  \item{\code{theta}}{paternal recombination rate}
  \item{\code{r2}}{\eqn{r^2} of maternal LD}
  \item{\code{logL}}{value of log likelihood function}
  \item{\code{unimodal}}{1 if likelihood is unimodal; 0 if likelihood is
   bimodal}
  \item{\code{critical}}{0 if parameter estimates were unique; 1 if parameter
    estimates were obtained via decision process}
  \item{\code{locus_Mb}}{physical distance between SNPs in Mbp}
}
}
\description{
Process raw results from \code{hsrecombi}, decide which out of
  two sets of estimates is more likely and prepare list of final results
}
\examples{
  ### test data
  data(targetregion)
  ### make list for paternal half-sib families
  hap <- makehaplist(daughterSire, hapSire)
  ### parameter estimates on a chromosome
  res <- hsrecombi(hap, genotype.chr, map.chr$SNP)
  ### pros-processing to achieve final and valid set of estimates
  final <- editraw(res, map.chr)
}
