% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_grid.R
\name{multivariate_grid}
\alias{multivariate_grid}
\title{Multivariate Grid}
\usage{
multivariate_grid(
  x,
  grid_size = 49L,
  trim = c(0.01, 0.99),
  strategy = c("uniform", "quantile"),
  na.rm = TRUE
)
}
\arguments{
\item{x}{A vector, matrix, or data.frame to turn into a grid of values.}

\item{grid_size}{Controls the approximate grid size. If \code{x} has p columns, then each
(non-discrete) column will be reduced to about the p-th root of \code{grid_size} values.}

\item{trim}{The default \code{c(0.01, 0.99)} means that values outside the
1\% and 99\% quantiles of non-discrete numeric columns are removed before calculation
of grid values. Set to \code{0:1} for no trimming.}

\item{strategy}{How to find grid values of non-discrete numeric columns?
Either "uniform" or "quantile", see description of \code{\link[=univariate_grid]{univariate_grid()}}.}

\item{na.rm}{Should missing values be dropped from the grid? Default is \code{TRUE}.}
}
\value{
A vector, matrix, or data.frame with evaluation points.
}
\description{
This function creates a multivariate grid. Each column of the input \code{x} is turned
(independently) into a vector of grid values via \code{\link[=univariate_grid]{univariate_grid()}}.
Combinations are then formed by calling \code{\link[=expand.grid]{expand.grid()}}.
}
\examples{
multivariate_grid(iris[1:2], grid_size = 4)
multivariate_grid(iris$Species)  # Works also in the univariate case
}
\seealso{
\code{\link[=univariate_grid]{univariate_grid()}}
}
