% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html5.R
\name{article}
\alias{article}
\title{Generate the <article> HTML tag.}
\usage{
article(..., attr = NULL, separate = FALSE, collapse = "")
}
\arguments{
\item{...}{A string or vector of content to pass to the tag.}

\item{attr}{A named list or named vector, names are attribute names and values are attribute values.}

\item{separate}{TRUE/FALSE, If TRUE, returns separate tags for each item of ...; if FALSE, returns one tag with the items of ... in the tag content.}

\item{collapse}{A string. If NULL, returns a vector the same length as ... instead of collapsing the tags into one string.}
}
\value{
A HTML tag string.
}
\description{
The <article> HTML element represents a self-contained composition in a document, page, application, or site, which is intended to be independently distributable or reusable (e.g., in syndication). Examples include: a forum post, a magazine or newspaper article, or a blog entry, a product card, a user-submitted comment, an interactive widget or gadget, or any other independent item of content.
}
\details{
Learn more at \url{https://developer.mozilla.org/en-US/docs/Web/HTML/Element/article}.
}
\examples{
article(attr = list(class = "test"))
}
