% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w_atmp_alt.R
\name{w_atmp_alt}
\alias{w_atmp_alt}
\title{Compute atmospheric pressure, function of altitude}
\usage{
w_atmp_alt(f_atmp, f_temp, alt0 = 0, alt)
}
\arguments{
\item{f_atmp}{File name of the known atmospheric pressure ts (mb)}

\item{f_temp}{File name of the air temperature at the known altitude (°C)}

\item{alt0}{Altitude of the known atmospheric pressure ts - default = 0 (m)}

\item{alt}{Altitude of the computed air- temperature ts (m)}
}
\value{
An hts file with the prefix co_ and the suffix _<alt>
}
\description{
Compute atmospheric pressure, function of altitude
}
\details{
The function computes an atmospheric pressure time-series at a given altitude,
based on a known atmospheric pressure time-series at a known altitude. It also needs
an air temperature ts at the known altitude.

The result is given for the common periods of the atmospheric pressure and the
air temperature ts, based on the result of the h_common function.
}
\author{
P. Chevallier - Nov 2021
}
