% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_krbc2pu.R
\name{calc_krbc2pu}
\alias{calc_krbc2pu}
\title{Back-calculates the Red Blood Cell to Unbound Plasma Partition Coefficient}
\usage{
calc_krbc2pu(
  Rb2p,
  Funbound.plasma,
  hematocrit = NULL,
  default.to.human = F,
  species = "Human",
  suppress.messages = T
)
}
\arguments{
\item{Rb2p}{The chemical blood:plasma concentration ratop}

\item{Funbound.plasma}{The free fraction of chemical in the presence of 
plasma protein
Rblood2plasma.}

\item{hematocrit}{Overwrites default hematocrit value in calculating
Rblood2plasma.}

\item{default.to.human}{Substitutes missing animal values with human values
if true.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{suppress.messages}{Determine whether to display certain usage
feedback.}
}
\description{
Given and observed ratio of chemial concentration in blood to plasma, this
function calculates a Red Blood Cell to unbound plasma (Krbc2pu) partition
coefficient that would be consistent with that observation.
}
\references{
Pearce, Robert G., et al. "Evaluation and calibration of high-throughput 
predictions of chemical distribution to tissues." Journal of 
pharmacokinetics and pharmacodynamics 44.6 (2017): 549-565.

Ruark, Christopher D., et al. "Predicting passive and active tissue: plasma 
partition coefficients: interindividual and interspecies variability." 
Journal of pharmaceutical sciences 103.7 (2014): 2189-2198.
}
\author{
John Wambaugh and Robert Pearce
}
\keyword{Parameter}
