% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_analytic_css_3compss.R
\name{calc_analytic_css_3compss}
\alias{calc_analytic_css_3compss}
\title{Calculate the analytic steady state concentration for the three compartment
steady-state model}
\usage{
calc_analytic_css_3compss(
  chem.name = NULL,
  chem.cas = NULL,
  dtxsid = NULL,
  parameters = NULL,
  hourly.dose = 1/24,
  concentration = "plasma",
  suppress.messages = FALSE,
  recalc.blood2plasma = FALSE,
  tissue = NULL,
  restrictive.clearance = TRUE,
  bioactive.free.invivo = FALSE,
  ...
)
}
\arguments{
\item{chem.name}{Either the chemical name, CAS number, or the parameters must 
be specified.}

\item{chem.cas}{Either the chemical name, CAS number, or the parameters must 
be specified.}

\item{dtxsid}{EPA's 'DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{parameters}{Chemical parameters from parameterize_pbtk (for model = 
'pbtk'), parameterize_3comp (for model = '3compartment), 
parameterize_1comp(for model = '1compartment') or parameterize_steadystate 
(for model = '3compartmentss'), overrides chem.name and chem.cas.}

\item{hourly.dose}{Hourly dose rate mg/kg BW/h.}

\item{concentration}{Desired concentration type, 'blood' or default 'plasma'.}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{recalc.blood2plasma}{Recalculates the ratio of the amount of chemical 
in the blood to plasma using the input parameters. Use this if you have 
'altered hematocrit, Funbound.plasma, or Krbc2pu.}

\item{tissue}{Desired tissue concentration (defaults to whole body 
concentration.)}

\item{restrictive.clearance}{If TRUE (default), then only the fraction of
chemical not bound to protein is available for metabolism in the liver. If 
FALSE, then all chemical in the liver is metabolized (faster metabolism due
to rapid off-binding).}

\item{bioactive.free.invivo}{If FALSE (default), then the total concentration is treated
as bioactive in vivo. If TRUE, the the unbound (free) plasma concentration is treated as 
bioactive in vivo. Only works with tissue = NULL in current implementation.}

\item{...}{Additional parameters passed to parameterize function if 
parameters is NULL.}
}
\value{
Steady state plasma concentration in mg/L units
}
\description{
This function calculates the analytic steady state plasma or venous blood 
concentrations as a result of infusion dosing.
}
\author{
Robert Pearce and John Wambaugh
}
\keyword{3compss}
