% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_analytic_css_pbtk.R
\name{calc_analytic_css_pbtk}
\alias{calc_analytic_css_pbtk}
\title{Calculate the analytic steady state plasma concentration for model pbtk.}
\usage{
calc_analytic_css_pbtk(
  chem.name = NULL,
  chem.cas = NULL,
  dtxsid = NULL,
  parameters = NULL,
  hourly.dose = 1/24,
  concentration = "plasma",
  suppress.messages = FALSE,
  recalc.blood2plasma = FALSE,
  tissue = NULL,
  restrictive.clearance = TRUE,
  bioactive.free.invivo = FALSE,
  ...
)
}
\arguments{
\item{chem.name}{Either the chemical name, CAS number, or the parameters must 
be specified.}

\item{chem.cas}{Either the chemical name, CAS number, or the parameters must 
be specified.}

\item{dtxsid}{EPA's 'DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{parameters}{Chemical parameters from parameterize_pbtk (for model = 
'pbtk'), parameterize_3comp (for model = '3compartment), 
parameterize_1comp(for model = '1compartment') or parameterize_steadystate 
(for model = '3compartmentss'), overrides chem.name and chem.cas.}

\item{hourly.dose}{Hourly dose rate mg/kg BW/h.}

\item{concentration}{Desired concentration type, 'blood', 'tissue', or default 'plasma'.}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{recalc.blood2plasma}{Recalculates the ratio of the amount of chemical 
in the blood to plasma using the input parameters. Use this if you have 
'altered hematocrit, Funbound.plasma, or Krbc2pu.}

\item{tissue}{Desired tissue conentration (defaults to whole body 
concentration.)}

\item{restrictive.clearance}{If TRUE (default), then only the fraction of
chemical not bound to protein is available for metabolism in the liver. If 
FALSE, then all chemical in the liver is metabolized (faster metabolism due
to rapid off-binding).}

\item{bioactive.free.invivo}{If FALSE (default), then the total concentration is treated
as bioactive in vivo. If TRUE, the the unbound (free) plasma concentration is treated as 
bioactive in vivo. Only works with tissue = NULL in current implementation.}

\item{...}{Additional parameters passed to parameterize function if 
parameters is NULL.}
}
\value{
Steady state plasma concentration in mg/L units
}
\description{
This function calculates the analytic steady state concentration (mg/L) as a result
of oral infusion dosing. Concentrations are returned for plasma by default, but various
tissues or blood concentrations can also be given as specified.
}
\details{
The PBTK model (Pearce et al., 2017) predicts the amount of chemical in
various tissues of the body. A system of oridinary
differential equations describes how the amounts in each tissue change as 
a function of time. The analytic steady-state equation was found by 
algebraically solving for the tissue concentrations that result in each
equation being zero -- thus determining the concentration at which there is no change
over time as the result of a fixed infusion dose rate. 

The analytical solution is:
\deqn{C^{ss}_{ven} = \frac{dose rate * \frac{Q_{liver} + Q_{gut}}{\frac{f_{up}}{R_{b:p}}*Cl_{metabolism} + (Q_{liver}+Q_{gut})}}{Q_{cardiac} - \frac{(Q_{liver} + Q_{gut})^2}{\frac{f_{up}}{R_{b:p}}*Cl_{metabolism} + (Q_{liver}+Q_{gut})} - \frac{(Q_{kidney})^2}{\frac{f_{up}}{R_{b:p}}*Q_{GFR}+Q_{kideny}}-Q_{rest}}}{%
C_ven_ss =(dose rate * (Q_liver + Q_gut) / (f_up/Rb2p*Cl_metabolism + (Q_liver + Qgut)))/(Q_cardiac - (Q_liver + Qgut)^2/(f_up/Rb2p*Cl_metabolism + (Q_liver + Qgut)) - (Q_kidney)^2/(f_up/Rb2p*Q_gfr + Q_kidney) - Q_rest)}
\deqn{C^{ss}_{plasma} = \frac{C^{ss}_{ven}}{R_{b:p}}}{%
      C_ss = C_ven_ss/Rb2p}
\deqn{C^{ss}_{tissue} = \frac{K_{tissue:fuplasma}*f_{up}}{R_{b:p}}*C^{ss}_{ven}}{%
       C_tissue_ss = K_tissue2fuplasma*f_up*C_ven_ss/Rb2p}
 where Q_cardiac is the cardiace output, Q_gfr is the glomerular filtration
rate in the kidney, other Q's indicate blood flows to various tissues, 
Cl_metabolism is the chemical-specific whole liver metabolism clearance,
f_up is the chemical-specific fraction unbound n plasma, R_b2p is the 
chemical specific ratio of concentrations in blood:plasma, K_tissue2fuplasma
is the chemical- and tissue-specufic equilibrium partition coefficient
and dose rate has  units of mg/kg/day.
}
\references{
Pearce, Robert G., et al. "Httk: R package for high-throughput
toxicokinetics." Journal of statistical software 79.4 (2017): 1.
}
\seealso{
\code{\link{calc_analytic_css}}

\code{\link{parameterize_pbtk}}
}
\author{
Robert Pearce and John Wambaugh
}
\keyword{pbtk}
