% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{get.immunobase.snps}
\alias{get.immunobase.snps}
\title{Download GWAS hits from t1dbase.org}
\usage{
get.immunobase.snps(disease = "T1D", snps.only = TRUE, show.codes = FALSE)
}
\arguments{
\item{disease}{integer (1-28), or character (abbreviation), or full name of one of the listed
diseases. A full list of options can be obtained by setting show.codes=TRUE.}

\item{snps.only}{logical, default is just to return a list of rs-ids. Setting FALSE gives a table}

\item{show.codes}{logical, if set to TRUE, instead of looking up t1dbase, will simply return
a table of available diseases with their index numbers and abbreviations.}
}
\value{
A character vector of SNP rs-ids
}
\description{
Deprecated as this data is no longer available online
Retrieve human disease top GWAS hits from t1dbase in build hg19 coords (37).
28 Diseases currently available
}
\examples{
get.immunobase.snps(show.codes=TRUE) # show codes/diseases available to download
\donttest{
get.immunobase.snps(disease="CEL") # get SNP ids for celiac disease
get.immunobase.snps(disease="AS") # get SNP ids for Ankylosing Spondylitis in build-37/hg19
get.immunobase.snps(disease=27) # get SNP ids for Alopecia Areata
get.immunobase.snps("Vitiligo")
}
}
\author{
Nicholas Cooper \email{nick.cooper@cimr.cam.ac.uk}
}
\references{
PMID: 20937630
}

