% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_exposure.R
\name{map_event_exposure}
\alias{map_event_exposure}
\title{Map county-level exposure based on reported events}
\usage{
map_event_exposure(storm_id, event_type, add_track = TRUE)
}
\arguments{
\item{storm_id}{Character vector with the storm for which to map events
(e.g., \code{"Katrina-2005"})}

\item{event_type}{Character string with the type of event to use to identify
county exposures. Options include \code{"flood"}, \code{"tornado"},
\code{"wind"}, and \code{"tropical storm"}.}

\item{add_track}{TRUE / FALSE of whether to add the storm's track to the map. The
default is TRUE.}
}
\value{
A map showing whether eastern US counties were exposed or unexposed
   to a specific storm based on event listings.
}
\description{
Map counties as "exposed" or "unexposed" based on the criterion that the county
had an event listing of a specified type in the NOAA Storm Events database.
For more information on the underlying data, see the helpfile for the
\code{storm_events} dataset.
}
\note{
Note that flood events are not available for any year before 1996.
}
\examples{
# Ensure that data package is available before running the example.
#  If it is not, see the `hurricaneexposure` package vignette for details
# on installing the required data package.
if (requireNamespace("hurricaneexposuredata", quietly = TRUE)) {

map_event_exposure(storm_id = "Floyd-1999", event_type = "flood")
map_event_exposure(storm_id = "Floyd-1999", event_type = "tornado")
map_event_exposure(storm_id = "Floyd-1999", event_type = "wind")
map_event_exposure(storm_id = "Floyd-1999", event_type = "tropical_storm")
}
}
