% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_exposure.R
\name{map_tracks}
\alias{map_tracks}
\title{Plot Atlantic basin hurricane tracks}
\usage{
map_tracks(storms, plot_object = NULL, padding = 2,
  plot_points = FALSE, alpha = 1, color = "firebrick")
}
\arguments{
\item{storms}{Character vector with the names of all storms to plot.
This parameter must use the unique storm identifiers from the
`storm_id` column of the `hurr_tracks` dataframe.}

\item{plot_object}{NULL or the name of a ggplot object to use as the
underlying plot object. If NULL, the function will generate a new
map of the eastern US states using `default_map`.}

\item{padding}{Numerical value giving the number of degrees to add to the
outer limits of the plot object (or default map if `plot_object` is
left as NULL) when cropping hurricane tracks.}

\item{plot_points}{TRUE / FALSE indicator of whether to include points,
as well as lines, when plotting the hurricane tracks. These points show
the times for which observations were recorded in the hurricane track data.}

\item{alpha}{Numerical value designating the amount of transparency to
use for plotting tracks.}

\item{color}{Character string giving the color to use to plot the tracks.}
}
\value{
Returns a ggplot object with plotting data for the storm tracks
   of the selected storms. This object can be printed directly or added
   to with other \code{ggplot2} commands.
}
\description{
Plot the tracks of any selected storms in the hurricane tracking
   dataset for the Atlantic basin. This function allows you to
   plot a new map or add the tracks to an existing ggplot object.
}
\examples{
# Ensure that data package is available before running the example.
#  If it is not, see the `hurricaneexposure` package vignette for details
# on installing the required data package.
if (requireNamespace("hurricaneexposuredata", quietly = TRUE)) {

map_tracks(storms = "Sandy-2012")
map_tracks(storms = "Floyd-1999", plot_points = TRUE)
map_tracks(storms = c("Sandy-2012", "Floyd-1999"))
a <- map_tracks(storms = "Sandy-2012", color = "blue", alpha = 0.3)
b <- map_tracks(storms = "Floyd-1999", plot_object = a)
b
}
}
