% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_exposure.R
\name{multi_county_distance}
\alias{multi_county_distance}
\title{Hurricane exposure by distance for communities}
\usage{
multi_county_distance(communities, start_year, end_year, dist_limit)
}
\arguments{
\item{communities}{A dataframe with the FIPS codes for all counties within
each community. It must include columns with a column identifier
(\code{commun}) and with the FIPS codes of counties included in each
community (\code{fips}). See the example code.}

\item{start_year}{Four-digit integer with first year to consider.}

\item{end_year}{Four-digit integer with last year to consider.}

\item{dist_limit}{Maximum distance, in kilometers, of how close the storm
track must come to the county's population mean center to classify
the county as "exposed" to the storm.}
}
\value{
Returns the same type dataframe as \code{county_distance},
   but with storms listed by community instead of county.
}
\description{
This function takes a dataframe with multi-county communities and returns a
community-level dataframe of "exposed" storms, based on the shortest distance
between the storm's track and the population-based centers of each county
in the community.
}
\examples{
# Ensure that data package is available before running the example.
#  If it is not, see the `hurricaneexposure` package vignette for details
# on installing the required data package.
if (requireNamespace("hurricaneexposuredata", quietly = TRUE)) {

communities <- data.frame(community_name = c(rep("ny", 6), "no", "new"),
                         fips = c("36005", "36047", "36061",
                                  "36085", "36081", "36119",
                                  "22071", "51700"))
distance_df <- multi_county_distance(communities = communities,
                                     start_year = 1995, end_year = 2005,
                                     dist_limit = 75)
}
}
