% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{valign}
\alias{valign}
\alias{valign<-}
\alias{set_valign}
\alias{valign.huxtable}
\alias{valign<-.huxtable}
\title{Get or Set Vertical Alignment}
\usage{
valign(ht)
valign(ht) <- value
set_valign(ht, row, col, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A character vector or matrix which may be 'top', 'middle', 'bottom' or \code{NA}. Set to \code{NA} to reset to the default.}

\item{row}{A row specifier.}

\item{col}{A column specifier.}
}
\value{
For \code{valign}, the \code{valign} attribute.
For \code{set_valign}, the \code{ht} object.
}
\description{
Functions to get or set the vertical alignment property of huxtable table cells.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
valign(ht) <-  'top'
valign(ht)

}
