% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{insert_column}
\alias{insert_column}
\alias{insert_row}
\title{Insert a row or column}
\usage{
insert_column(ht, ..., after = 0, copy_cell_props = TRUE)

insert_row(ht, ..., after = 0, copy_cell_props = TRUE)
}
\arguments{
\item{ht}{A huxtable.}

\item{...}{Cell contents.}

\item{after}{Insert the row/column after this position. 0 (the default) inserts as the first row/column.}

\item{copy_cell_props}{Copy cell properties from the previous row or column (if after > 0). See \code{\link{cbind.huxtable}}.}
}
\value{
The modified huxtable
}
\description{
These convenience functions wrap \code{cbind} or \code{rbind} for huxtables to insert
a single row.
}
\examples{
ht <- hux(1:5, 1:5, 1:5)
ht <- insert_row(ht, 2.5, 2.5, 2.5, after = 2)
ht
ht <- insert_column(ht, 1, 2, 2.5, 3, 4, 5, after = 3)
ht
}
